package ru.yandex.common.abt;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author zador
 */
public class AbtTest {
  private static final String ABT_CONFIG = "1\n" +
      "1\n" +
      "3\n" +
      "i\t0\t2\t1\t2\n" +
      "T\t0\t2\t\t2\n" +
      "S\t0";
  @Rule
  public ExpectedException thrown = ExpectedException.none();
  private String ABT_CONFIG_PATH;

  @Before
  public void setUp() throws Exception {
    final File file;
    try (InputStream in = Abt.class.getClassLoader().getResourceAsStream("usersplit.conf")) {
      file = File.createTempFile("usersplit.", "");
      file.deleteOnExit();
      Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
    this.ABT_CONFIG_PATH = file.getAbsolutePath();
  }

  @Test
  public void testClassify() throws Exception {
    final Abt abt = new Abt(ABT_CONFIG_PATH);
    assertTrue(abt.isAllocated());
    final String[] classify = abt.classifyAndGetParams(
        null,
        null,
        null,
        null,
        null,
        System.currentTimeMillis(),
        "127.0.0.1",
        318,
        "searchapp",
        "touch",
        null,
        "production",
        "04a38357120957e08f2d828e4889a8ec",
        "android",
        "YandexSearch",
        null,
        null,
        false,
        "",
        ""
    );
    assertTrue(classify.length == 0);
  }

  @Test
  public void test() throws Exception {
    final Abt abt = new Abt(ABT_CONFIG_PATH);
    assertTrue(abt.isAllocated());
    assertEquals("7", abt.version());
  }

  @Test
  public void testReloads() throws Exception {
    final Abt abt = new Abt(ABT_CONFIG_PATH);
    assertEquals("7", abt.version());
    abt.reloads(ABT_CONFIG);
    assertEquals("1", abt.version());
  }

  @Test
  public void testReload() throws Exception {
    final Abt abt = new Abt(ABT_CONFIG_PATH);
    assertEquals("7", abt.version());
    abt.reloads(ABT_CONFIG);
    assertEquals("1", abt.version());
    abt.reload(ABT_CONFIG_PATH);
    assertEquals("7", abt.version());
  }

  @Test
  public void testDelete() throws Exception {
    final Abt abt = new Abt(ABT_CONFIG_PATH);
    abt.delete();
    assertFalse(abt.isAllocated());
    thrown.expect(AssertionError.class);
    abt.version();
  }

  @Test
  public void testAssertion() throws Exception {
    final Abt abt = new Abt(ABT_CONFIG_PATH);
    abt.delete();
    thrown.expect(AssertionError.class);
    abt.version();
  }

  @Test
  public void testDoubleDelete() throws Exception {
      final Abt abt = new Abt(ABT_CONFIG_PATH);
      abt.delete();
      assertFalse(abt.isAllocated());
      thrown.expect(AssertionError.class);
      abt.delete();
  }
}
