#include "ru_yandex_apphost_AppHost.h"

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <apphost/api/service/cpp/service.h>

using namespace NAppHost;

static jfieldID  implFID;
static jmethodID acceptRequestMID;
static jclass    appHostRequestClass;
static jmethodID appHostRequestCtor;
static JavaVM    *jvm;

jint JNI_OnLoad(JavaVM *jvm, void *)
{
    JNIEnv *env;
    if (jvm->GetEnv((void**) &env, JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }
    ::jvm = jvm;
    return JNI_VERSION_1_6;
}

JNIEXPORT void JNICALL Java_ru_yandex_apphost_AppHost_registerNatives(JNIEnv *env, jclass objClass)
{
  implFID = env->GetFieldID(objClass, "impl", "J");

  jclass consumerClass = (jclass) env->NewGlobalRef(env->FindClass("Ljava/util/function/Consumer;"));
  acceptRequestMID = env->GetMethodID(consumerClass, "accept", "(Ljava/lang/Object;)V");

  appHostRequestClass = (jclass) env->NewGlobalRef(env->FindClass("Lru/yandex/apphost/AppHostRequest;"));
  appHostRequestCtor = env->GetMethodID(appHostRequestClass, "<init>", "(J)V");
}

JNIEXPORT void JNICALL Java_ru_yandex_apphost_AppHost_start0(JNIEnv *env, jobject obj, jint port, jint threadsCount, jobject callback)
{
  jobject sharedCallback = env->NewGlobalRef(callback);

  auto loop = new TLoop();
  env->SetLongField(obj, implFID, (long) loop);

  auto fn = [&, sharedCallback](IServiceContext& ctx) {
    JNIEnv *threadEnv;
    jvm->AttachCurrentThreadAsDaemon((void **) &threadEnv, nullptr);
    jobject request = threadEnv->NewObject(appHostRequestClass, appHostRequestCtor, (long) &ctx);
    threadEnv->CallVoidMethod(sharedCallback, acceptRequestMID, request);
  };

  loop->Add(port, fn);
  loop->ForkLoop(threadsCount);
}

JNIEXPORT void JNICALL Java_ru_yandex_apphost_AppHost_stop0(JNIEnv *env, jobject obj)
{
  TLoop *loop = (TLoop*) env->GetLongField(obj, implFID);
  if (loop) {
    loop->SyncStopFork();
    delete loop;
    env->SetLongField(obj, implFID, 0);
  }
}

