#include "ru_yandex_apphost_AppHostRequest.h"

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <apphost/api/service/cpp/service.h>
#include <library/cpp/json/json_reader.h>


using namespace NAppHost;

static jfieldID contextFID;
static jclass   stringClass;

JNIEXPORT void JNICALL Java_ru_yandex_apphost_AppHostRequest_registerNatives(JNIEnv *env, jclass objClass)
{
  contextFID = env->GetFieldID(objClass, "ctx", "J");
  stringClass = (jclass) env->NewGlobalRef(env->FindClass("Ljava/lang/String;"));
}

JNIEXPORT jstring JNICALL Java_ru_yandex_apphost_AppHostRequest_getFirst(JNIEnv *env, jobject obj, jstring type, jstring jsonPath)
{
  IServiceContext *ctx = (IServiceContext*) env->GetLongField(obj, contextFID);

  const char* _type = env->GetStringUTFChars(type, nullptr);
  const NJson::TJsonValue &node = ctx->GetOnlyItem(_type);
  env->ReleaseStringUTFChars(type, _type);

  const char* _jsonPath = env->GetStringUTFChars(jsonPath, nullptr);
  const NJson::TJsonValue *value = node.GetValueByPath(_jsonPath, '.');
  env->ReleaseStringUTFChars(jsonPath, _jsonPath);

  if (value) {
    const char *s = value->GetStringRobust().c_str();
    return env->NewStringUTF(s);
  }

  return nullptr;
}

JNIEXPORT jobjectArray JNICALL Java_ru_yandex_apphost_AppHostRequest_getAll(JNIEnv *env, jobject obj, jstring type, jstring jsonPath)
{
  IServiceContext *ctx = (IServiceContext*) env->GetLongField(obj, contextFID);

  const char* _type = env->GetStringUTFChars(type, nullptr);
  const NJson::TJsonValue &node = ctx->GetOnlyItem(_type);
  env->ReleaseStringUTFChars(type, _type);

  const char* _jsonPath = env->GetStringUTFChars(jsonPath, nullptr);
  const NJson::TJsonValue *value = node.GetValueByPath(_jsonPath, '.');
  env->ReleaseStringUTFChars(jsonPath, _jsonPath);
  if (!value) {
      return nullptr;
  }

  if (value->IsArray()) {
      const NJson::TJsonValue::TArray &array = value->GetArray();
      size_t size = array.size();
      jobjectArray result = env->NewObjectArray(size, stringClass, nullptr);
      for (size_t i = 0; i < size; ++i) {
          const char *s = array[i].GetStringRobust().c_str();
          env->SetObjectArrayElement(result, i, env->NewStringUTF(s));
      }
      return result;
  }

  jobjectArray result = env->NewObjectArray(1, stringClass, nullptr);
  const char *s = value->GetStringRobust().c_str();
  env->SetObjectArrayElement(result, 0, env->NewStringUTF(s));
  return result;
}

JNIEXPORT void JNICALL Java_ru_yandex_apphost_AppHostRequest_reply(JNIEnv *env, jobject obj, jstring type, jstring answer)
{
  IServiceContext *ctx = (IServiceContext*) env->GetLongField(obj, contextFID);

  const char* _type = env->GetStringUTFChars(type, nullptr);
  const char* _answer = env->GetStringUTFChars(answer, nullptr);

  NJson::TJsonValue answerJson;
  NJson::ReadJsonFastTree(_answer, &answerJson, false);

  ctx->AddItem(std::move(answerJson), _type);

  env->ReleaseStringUTFChars(type, _type);
  env->ReleaseStringUTFChars(answer, _answer);
}

