package ru.yandex.apphost;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;

/**
 * @author imakunin
 */
public class AppHostServant {

  /*
    context.json = [
      {
        "name": "VAAS",
        "results": [{
                "type": "vaas",
                "k1": "v1",
                "k3": ["1", "2", "3"],
                "k4": {
                    "k4_1": "111",
                    "k4_2": "222"
                }
            }]
      }
    ]

    cmd: arcadia/apphost/tools/servant_client$ ./servant_client localhost:8182 context.json
   */

  public static void main(String[] args) throws InterruptedException {
    CountDownLatch latch = new CountDownLatch(1);
    AppHost instance = AppHost.start(8182, 2, r -> {
      System.out.println("got it!");

      System.out.println("k1=" + r.getFirst("vaas", "k1"));
      System.out.println("k1=" + Arrays.toString(r.getAll("vaas", "k1")));

      System.out.println("k2=" + r.getFirst("vaas", "k2"));
      System.out.println("k2=" + Arrays.toString(r.getAll("vaas", "k2")));

      System.out.println("k3=" + r.getFirst("vaas", "k3"));
      System.out.println("k3=" + Arrays.toString(r.getAll("vaas", "k3")));

      System.out.println("k4.1=" + r.getFirst("vaas", "k4.k4_1"));
      System.out.println("k4.2=" + r.getFirst("vaas", "k4.k4_2"));

      r.reply("VAAS", "{\"foo\":\"bar\"}");
      latch.countDown();
    });
    latch.await();
    instance.stop();
  }

}
