#include <util/stream/str.h>
#include <util/generic/yexception.h>
#include <ysite/yandex/filter/dochilite.h>

extern "C" int HiliteHtml(const char* doc, int docLen, const char* query,
                    const char* charset, const char* startMark, const char* endMark,
                    char** result, int* resultSize) {
    Y_ASSERT(doc && query && charset && startMark && endMark && result && resultSize);
    try {
        TStringStream reply;
        HiliteDocument(doc, docLen, query, charset, startMark, endMark, reply);
        char* replyMem = new char[+reply + 1];
        memcpy(replyMem, ~reply, +reply + 1); // copy 0 also
        *result = replyMem;
        *resultSize = +reply;
    } catch(yexception& e) {
        TString error = e.what();
        char* replyMem = new char[+error + 1];
        memcpy(replyMem, ~error, +error+ 1); // copy 0 also
        *result = replyMem;
        *resultSize = +error;
        return -1;
    }
    return 0;
}
extern "C" void ReleaseHilited(char* doc) {
    delete[] doc;
}
