// package com.yandex.arcadia.htnorm;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform; 
import com.sun.jna.Pointer; 
import com.sun.jna.ptr.PointerByReference; 
import com.sun.jna.ptr.IntByReference; 
import java.io.File;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class Hilite{
    // jna interface reflects shared library - do not modify without updating htnorm
    public interface IHilite extends Library {
        // Use byte[] instead of String for source to avoid implicit conversion
        // reply is UTF8 encoded byte[]
        // on error -1 is returned, otherwise 0
        int HiliteHtml(byte[] document, int docLen, String query, String charset, String startMark, String endMark, PointerByReference replyPtr, IntByReference replySize);
    	void ReleaseHilited(Pointer resultDoc);
    };

    public class HiliteException extends Exception {
        public HiliteException(String s) {
            super(s);
        }
    };

    private static byte[] getBytesFromFile(File file) throws IOException {
         InputStream is = new FileInputStream(file);
         long length = file.length();
         if (length > Integer.MAX_VALUE) {
             /// @todo: File is too large
         }
     
         byte[] bytes = new byte[(int)length];
     
         // Read in the bytes
         int offset = 0;                                                                                                                        
         int numRead = 0;
         while (offset < bytes.length
                && (numRead=is.read(bytes, offset, bytes.length-offset)) >= 0) {
             offset += numRead;
         }
     
         // Ensure all the bytes have been read in
         if (offset < bytes.length) {
             // FIXME resource leak, use try-finally { is.close(); }
             throw new IOException("Could not completely read file "+file.getName());
         }
     
         // Close the input stream and return bytes
         is.close();
         return bytes;
     } 

    public static void main(String[] args) {
        String startMark = "[HL]";
        String endMark = "[/HL]";
        String query = "";
        String charset = "";
	try {
		String filename = args[0];
		if(args.length >= 5) {
		    query = args[1];
		    charset = args[2];
		    startMark = args[3];
		    endMark = args[4];
		}
		byte[] content = getBytesFromFile(new File(filename));
		Hilite obj = new Hilite();
		String r = obj.hilite(content, query, charset, startMark, endMark);
		System.out.println(r);
	} 
	catch(IOException e) {
		System.err.println("cannot read file: " + e.toString());
	}
	catch(HiliteException e) {
	        System.err.println("cannot hilite: " + e.toString());
	}
	
    }

    private IHilite hiliter;

    public Hilite() {
        hiliter = (IHilite)Native.loadLibrary("hiliteso", IHilite.class);
    }

    public String hilite(byte[] doc, String query, String charset, String startMark, String endMark) throws HiliteException
    {	
        PointerByReference replyPtr = new PointerByReference();
        IntByReference replySize = new IntByReference();
        
	int result = hiliter.HiliteHtml(doc, doc.length, query, charset, startMark, endMark, replyPtr, replySize);
	
	Pointer p = replyPtr.getValue();
	byte[] buffer = p.getByteArray(0, replySize.getValue());
	String reply = "";
	try {
	    reply = new String(buffer, "UTF-8");
	}
	catch(java.io.UnsupportedEncodingException e) {
	    System.err.println("UTF-8 is not supported: " + e.toString());
	}
	hiliter.ReleaseHilited(p);

	if(result != 0)
	    throw new HiliteException(reply);

	return reply;
    }
};
