#!/bin/sh

RPM_FOLDER=x86_64
DEST_HOST=dist.mail.yandex.net
DEST_REPO=/repo/mail-rhel/6/x86_64/


ec() {
    echo "$@" >&2
    "$@"
}


ec clear

read -n 1 -p "Press ENTER to delete ${RPM_FOLDER}/ and run rpmbuild"
ec rm -rf "${RPM_FOLDER}"

ec rpmbuild -bb -v hiliteso.spec

FILE=`ls -1 "${RPM_FOLDER}"/*.rpm | head -n 1`
read -n 1 -p "Found built package: '${FILE}'. Press ENTER to confirm its upload"

ec scp ${FILE} ${DEST_HOST}:${DEST_REPO}
ec ssh ${DEST_HOST} "sudo createrepo --update ${DEST_REPO}"
