#include <library/cpp/charset/doccodes.h>
#include <library/cpp/html/dehtml/dehtml.h>

#include "ru_yandex_common_util_htmlstripper_HtmlStripper.h"

#include <stdio.h>

jint JNI_OnLoad(JavaVM *jvm, void *)
{
    JNIEnv *env;
    if (jvm->GetEnv((void**) &env, JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }

    return JNI_VERSION_1_6;
}

JNIEXPORT void JNICALL Java_ru_yandex_common_util_htmlstripper_HtmlStripper_registerNatives(JNIEnv *, jclass)
{
}

struct RAIIStr {
    JNIEnv *env;
    jstring js;
    const char *s;
    char *out = nullptr;
    RAIIStr(JNIEnv *env, jstring js, const char *s)
        : env(env), js(js), s(s) {}
    ~RAIIStr() {
        if (s && env) {
            env->ReleaseStringUTFChars(js, s);
        }
        if (out) {
            delete[] out;
            out = nullptr;
        }
    }
};

JNIEXPORT jstring JNICALL Java_ru_yandex_common_util_htmlstripper_HtmlStripper_strip(JNIEnv *env, jclass, jstring text)
{
    const char *s = env->GetStringUTFChars(text, nullptr);
    if (!s) {
        return nullptr;
    }

    RAIIStr ctx(env, text, s);

    size_t s_len = env->GetStringUTFLength(text);
    size_t out_len = s_len * 2;
    ctx.out = new char[out_len];

    int mode = HtmlStripMode::HSM_ENTITY
             | HtmlStripMode::HSM_SPACE
             | HtmlStripMode::HSM_TRASH;

    THtmlStripper::Strip(mode, ctx.out, out_len, s, s_len, ECharset::CODES_UTF8);

    if ( out_len <= 0 ) {
        return nullptr;
    }

    ctx.out[out_len] = 0;
    return env->NewStringUTF(ctx.out);
}

JNIEXPORT void JNICALL Java_ru_yandex_common_util_htmlstripper_HtmlStripper_destroy(JNIEnv *, jobject)
{
}

