#include "inflector.h"
#include <kernel/inflectorlib/pluralize/pluralize.h>
#include <util/charset/wide.h>

size_t pluralize(const char* text, int targetNumber, int targetCase, int lang, bool isAnimated,
                 char* dst, size_t dstLen) {
    TUtf16String resultUtf16 = NInfl::Pluralize(UTF8ToWide(text), targetNumber, static_cast<EGrammar>(targetCase), static_cast<ELanguage>(lang), isAnimated);
    TString result = WideToUTF8(resultUtf16);
    if (result.size() > dstLen) {
        return 0;
    }

    return result.copy(dst, dstLen);
}

size_t singularize(const char* text, int sourceNumber, int lang, char* dst, size_t dstLen) {
    TUtf16String resultUtf16 = NInfl::Singularize(UTF8ToWide(text), sourceNumber, static_cast<ELanguage>(lang));
    TString result = WideToUTF8(resultUtf16);
    if (result.size() > dstLen) {
        return 0;
    }

    return result.copy(dst, dstLen);
}
