package ru.yandex.kernel.inflector;

import java.util.stream.Stream;

//copy from https://a.yandex-team.ru/arc_vcs/kernel/lemmer/dictlib/grammar_enum.h
public enum Grammar {
    gInvalid(0),
    gBefore(126),
    /*--------------------*/
    gPostposition(127), // POSTP
    gFirst(gPostposition.value),
    gAdjective(128),     // A      // Nomenus
    gAdverb(129),        // ADV
    gComposite(130),     // COM(P)
    gConjunction(131),   // CONJ
    gInterjunction(132), // INTJ
    gNumeral(133),       // NUM
    gParticle(1344),      // PCL
    gPreposition(135),   // PRE(P)
    gSubstantive(136),   // S
    gVerb(137),          // V
    gAdjNumeral(138),    // ANUM
    gAdjPronoun(139),    // APRO
    gAdvPronoun(140),    // ADVPRO
    gSubstPronoun(141),  // SPRO
    gArticle(142),       // артикли
    gPartOfIdiom(143),   // части идиом (прежде всего иностр. слов)
    gLastPartOfSpeech(gPartOfIdiom.value),
    gReserved(144),       // зарезервировано    // особые пометы
    gAbbreviation(145),   // сокращения
    gIrregularStem(146),  // чередование в корне (или супплетивизм)
    gInformal(147),       // разговорная форма
    gDistort(148),        // искаженная форма
    gContracted(149),     // стяжённая форма (фр. q' и т.п.)
    gObscene(150),        // обсц
    gRare(151),           // редк
    gAwkward(152),        // затр
    gObsolete(153),       // устар
    gSubstAdjective(154), // адъект
    gFirstName(155),      // имя
    gSurname(156),        // фам
    gPatr(157),           // отч
    gGeo(158),            // гео
    gProper(159),         // собств
    gPresent(160),        // наст  // Tempus
    gNotpast(161),        // непрош
    gPast(162),           // прош
    gFuture(163),         // буд. время (фр., ит.)
    gPast2(164),          // фр. passe simple, ит. passato remoto
    gNominative(165),     // им    // Casus
    gGenitive(166),       // род
    gDative(167),         // дат
    gAccusative(168),     // вин
    gInstrumental(169),   // твор
    gAblative(170),       // пр
    gPartitive(171),      // парт(вин2)
    gLocative(172),       // местн(пр2)
    gVocative(173),       // звательный
    gSingular(174),       // ед    // Numerus
    gPlural(175),         // мн
    gGerund(176),         // деепр // Modus
    gInfinitive(177),     // инф
    gParticiple(178),     // прич
    gIndicative(179),     // изъяв
    gImperative(180),     // пов
    gConditional(181),    // усл. наклонение (фр., ит.)
    gSubjunctive(182),    // сослаг. накл. (фр., ит.)
    gShort(183),          // кр    // Gradus
    gFull(184),           // полн
    gSuperlative(185),    // прев
    gComparative(186),    // срав
    gPossessive(187),     // притяж
    gPerson1(188),        // 1-л   // Personae
    gPerson2(189),        // 2-л
    gPerson3(190),        // 3-л
    gFeminine(191),       // жен   // Gender (genus)
    gMasculine(192),      // муж
    gNeuter(193),         // сред
    gMasFem(194),         // мж
    gPerfect(195),        // сов   // Perfectum-imperfectum (Accept)
    gImperfect(196),      // несов
    gPassive(197),        // страд // Voice (Genus)
    gActive(198),         // действ
    gReflexive(199),      // возвратные
    gImpersonal(200),     // безличные
    gAnimated(201),       // од    // Animated
    gInanimated(202),     // неод
    gPraedic(203),        // прдк
    gParenth(204),        // вводн
    gTransitive(205),     // пе     //transitivity
    gIntransitive(206),   // нп
    gDefinite(207),       // опред. члены   //definiteness
    gIndefinite(208),     // неопред. члены

    gSimConj(209),       // сочинит. (для союзов)
    gSubConj(210),       // подчинит. (для союзов)
    gPronounConj(211),   // местоимение-союз ("я знаю, _что_ вы сделали прошлым летом")
    gCorrelateConj(212), // вторая зависимая часть парных союзов - "если ... _то_ ... ", "как ... _так_ и ..."

    gAuxVerb(213), //вспомогательный глагол в аналитической форме ("_будем_ думать")
    /*--------------------*/
    /* Additional grammemes for Turkish and Armenian */
    gDual(214),
    gPoss1p(215),
    gPoss1pSg(216),
    gPoss1pPl(217),
    gPoss2p(218),
    gPoss2pSg(219),
    gPoss2pPl(220),
    gPoss3p(221),
    gPoss3pSg(222),
    gPoss3pPl(223),
    gPredic1pSg(224),
    gPredic1pPl(225),
    gPredic2pSg(226),
    gPredic2pPl(227),
    gPredic3pSg(228),
    gPredic3pPl(229),
    gElative(230),
    gDerivedAdjective(231),
    gEvidential(232),
    gNegated(233),
    gPotential(234),
    gMedial(235),
    gHuman(236),
    gAssocPlural(237),
    gOptative(238),
    gConverb(239),
    gSimultaneous(240),
    gConnegative(241),
    gResultative(242),
    gSubjective(243),
    gCount(244), // счётная форма
    gGoodForm(245),
    gPredicPoss(246),
    gIntention(247),
    gHonorific(248),
    gEquative(249),
    gPredic(250),
    gObligatory(251),
    gImperfectTense(252), // имперфект (не путать с несовершенным видом, gImperfect)
    gMax(253);

    private final int value;

    Grammar(int value) {
        this.value = value;
    }

    public static Grammar from(String str) {
        return Stream.of(Grammar.values())
            .filter(g -> str.equalsIgnoreCase(g.name()))
            .findFirst()
            .orElse(null);
    }

    public int getValue() {
        return value;
    }
}
