#include "owner_canonizer.h"

#include <kernel/hosts/owner/owner.h>

void* InitOwnerCanonizer()
{
    try {
        auto canonizer = std::make_unique<TOwnerCanonizer>();
        canonizer->LoadTrueOwners();
        return canonizer.release();
    } catch (...) {
        return nullptr;
    }
}

void DeleteOwnerCanonizer(void* canonizer)
{
    delete static_cast<TOwnerCanonizer*>(canonizer);
}

size_t GetUrlOwner(void* canonizer, const char* url, char* dst, size_t dstLen)
{
    try {
        auto result = static_cast<TOwnerCanonizer*>(canonizer)->GetUrlOwner(url);
        if (result.length() >= dstLen) {
            return 0;
        }
        result.copy(dst, dstLen);
        return result.length();
    } catch (...) {
        return 0;
    }
}
