package ru.yandex.kernel.hosts.owner;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

public class OwnerCanonizerTest {

    OwnerCanonizer canonizer = new OwnerCanonizerImpl();

    @Test
    public void testSimple() {
        assertEquals("somesite.com", canonizer.getUrlOwner("blah.somesite.com"));
        assertEquals("do.nn.ru", canonizer.getUrlOwner("do.nn.ru"));
    }

    @Test
    public void testLivejournal() {
        assertEquals("kukutz.livejournal.com", canonizer.getUrlOwner("kukutz.livejournal.com"));
        assertEquals("someone.livejournal.com", canonizer.getUrlOwner("someone.livejournal.com"));
        assertEquals("chgk.livejournal.com", canonizer.getUrlOwner("https://chgk.livejournal.com/4025205.html"));
    }

    @Test
    public void testPunycode() {
        assertEquals("мвд.рф", canonizer.getUrlOwner("мвд.рф"));
        assertEquals("мвд.рф", canonizer.getUrlOwner("http://мвд.рф"));
        assertEquals("мвд.рф", canonizer.getUrlOwner("МВД.рф/бла-бла-бла.html"));
    }

    @Test
    public void testYandex() {
        assertEquals("maps.yandex.ru", canonizer.getUrlOwner("maps.yandex.ru"));
        assertEquals("mail.yandex.ru", canonizer.getUrlOwner("mail.yandex.ru"));
        assertEquals("www.yandex.ru", canonizer.getUrlOwner("www.yandex.ru"));
        assertEquals("yandex.ru", canonizer.getUrlOwner("yandex.ru"));
    }

    @Test
    public void testCornerCases() {
        assertEquals(null, canonizer.getUrlOwner(""));
        assertThrows(NullPointerException.class, () -> canonizer.getUrlOwner(null));
    }

}
