package ru.yandex.common.signurl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

/**
 * @author zador
 * @date 2019-03-12 21:53
 */
public class Signurl {
  private static final String LIBNAME = "signurl";

  static {
    try {
      loadLibrary();
    } catch (IOException e) {
      throw new UnsatisfiedLinkError(e.getMessage());
    }
  }

  private long self;

  public Signurl(final String key) {
    this(create(key));
  }

  private Signurl(long self) {
    if (self == 0L) {
      throw new OutOfMemoryError("Failure allocating native heap memory");
    }
    this.self = self;
  }

  private static void loadLibrary() throws IOException {
    try {
      System.loadLibrary(LIBNAME);
      return;
    } catch (UnsatisfiedLinkError ignored) {
    }
    final String libFileName = System.mapLibraryName(LIBNAME);
    final File file;
    try (InputStream in = Signurl.class.getClassLoader().getResourceAsStream(libFileName)) {
      if (in == null) {
        throw new IOException("Missing JNI library - " + libFileName);
      }
      final int pos = libFileName.lastIndexOf('.');
      file = File.createTempFile(libFileName.substring(0, pos), libFileName.substring(pos));
      file.deleteOnExit();
      Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
    System.load(file.getAbsolutePath());
  }

  private static native long create(final String key);

  private static native void delete(long self);

  private void delete() {
    assert this.self != 0L : "Signurl not loaded";
    delete(self);
    self = 0L;
  }

  @Override
  protected void finalize() throws Throwable {
    delete();
    super.finalize();
  }

  private native String crypt(long self, final String data);

  private native String decrypt(long self, final String data);

  public String Crypt(String data) {
    return this.crypt(this.self, data);
  }

  public String Decrypt(String data) {
    return this.decrypt(self, data);
  }
}
