package ru.yandex.common.signurl;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

/**
 * @author zador
 * @date 2019-03-13 01:45
 */
public class SignurlTest {
  private final static String data = "data";
  @Rule
  public final ExpectedException exception = ExpectedException.none();

  @Test
  public void cryptInvalidKey() {
    exception.expect(RuntimeException.class);
    new Signurl(null);
  }

  @Test
  public void crypt0() {
    final Signurl signurl = new Signurl("");
    final String encrypted = signurl.Crypt(data);
    final String decrypted = signurl.Decrypt(encrypted);
    Assert.assertNotEquals(data, encrypted);
    Assert.assertEquals(data, decrypted);
  }

  @Test
  public void crypt1() {
    final Signurl signurl = new Signurl("key");
    final String encrypted = signurl.Crypt(data);
    final String decrypted = signurl.Decrypt(encrypted);
    Assert.assertNotEquals(data, encrypted);
    Assert.assertEquals(data, decrypted);
  }

  @Test
  public void crypt2() {
    final Signurl signurl = new Signurl("jQm9NqfREKGKRNgHSGLV1A==");
    final String encrypted = signurl.Crypt(data);
    final String decrypted = signurl.Decrypt(encrypted);
    Assert.assertNotEquals(data, encrypted);
    Assert.assertEquals(data, decrypted);
  }

  @Test
  public void crypt3() {
    final Signurl signurl = new Signurl("jQm9NqfREKGKRNgHSGLV1A==");
    Assert.assertEquals(signurl.Crypt(""), signurl.Crypt(null));
  }
}