#include <util/generic/string.h>
#include <util/stream/str.h>
#include <library/cpp/resource/resource.h>
#include <uatraits/detector.hpp>

#include "ru_yandex_common_uatraits_Uatraits.h"

jclass getClassReference(JNIEnv *env, const char *classname) {
    jclass tempLocalClassRef = env->FindClass(classname);
    jclass globalRef = (jclass) env->NewGlobalRef(tempLocalClassRef);
    env->DeleteLocalRef(tempLocalClassRef);
    return globalRef;
}

static jint JNI_VERSION = JNI_VERSION_1_8;
static jclass ireClass;
static jclass iieClass;
static jclass stringClass;
static jstring emptyString;

jint JNI_OnLoad(JavaVM* jvm, void*) {
    JNIEnv* env;
    if (jvm->GetEnv(reinterpret_cast<void**>(&env), JNI_VERSION) != JNI_OK) {
        return JNI_ERR;
    }
    ireClass = getClassReference(env, "java/lang/RuntimeException");
    iieClass = getClassReference(env, "ru/yandex/common/uatraits/InitializationException");
    stringClass = getClassReference(env, "java/lang/String");
    emptyString = (jstring) env->NewGlobalRef(env->NewStringUTF(nullptr));
    return JNI_VERSION;
}

void JNI_OnUnload(JavaVM *jvm, void *) {
    JNIEnv* env;
    jvm->GetEnv(reinterpret_cast<void**>(&env), JNI_VERSION);
    env->DeleteGlobalRef(ireClass);
    env->DeleteGlobalRef(stringClass);
    env->DeleteGlobalRef(emptyString);
}

jlong Java_ru_yandex_common_uatraits_Uatraits_create__(JNIEnv*, jclass) {
    TString rawData;
    Y_VERIFY(NResource::FindExact("browser.xml", &rawData), "browser.xml not loaded");
    TStringInput in(rawData);
    auto obj = new uatraits::detector(rawData.data(), (int) rawData.size());
    return (long) obj;
}

jlong Java_ru_yandex_common_uatraits_Uatraits_create__Ljava_lang_String_2Ljava_lang_String_2(JNIEnv* env, jclass, jstring jprofiles, jstring jextras) {
    TString configRawData;
    Y_VERIFY(NResource::FindExact("browser.xml", &configRawData), "browser.xml not loaded");

    const char* profilesChars = env->GetStringUTFChars(jprofiles, 0);
    TString profilesRawData = TString(profilesChars);

    const char* extrasChars = env->GetStringUTFChars(jextras, 0);
    TString extrasRawData = TString(extrasChars);

    try{
        auto obj = new uatraits::detector(
            configRawData.data(), (int) configRawData.size(),
            profilesRawData.data(), (int) profilesRawData.size(),
            extrasRawData.data(), (int) extrasRawData.size()
        );
        return (long) obj;
    } catch (std::exception const &e) {
        env->ThrowNew(iieClass, e.what());
    }
    return 0;
}

void Java_ru_yandex_common_uatraits_Uatraits_delete(JNIEnv*, jclass, jlong jptr) {
    auto obj = (uatraits::detector*) jptr;
    delete obj;
}

jobjectArray Java_ru_yandex_common_uatraits_Uatraits_classify(JNIEnv* env, jobject, jlong jptr, jstring jagent) {
    auto obj = (uatraits::detector*) jptr;
    std::map<std::string, std::string> result;
    try {
        if (!jagent) {
            obj->detect("", result);
        } else {
            const char* agentChars = env->GetStringUTFChars(jagent, 0);
            std::string agent = agentChars;
            obj->detect(agent, result);
            env->ReleaseStringUTFChars(jagent, agentChars);
        };
    } catch (std::runtime_error e) {
        env->ThrowNew(ireClass, e.what());
    }
    jsize len = result.size();
    jobjectArray jresult = env->NewObjectArray(len * 2, stringClass, emptyString);
    jsize i = 0;
    for (auto it: result) {
        env->SetObjectArrayElement(jresult, i, env->NewStringUTF(it.first.c_str()));
        env->SetObjectArrayElement(jresult, i + len, env->NewStringUTF(it.second.c_str()));
        ++i;
    }
    return jresult;
}

#undef GET_STR_ARG
