package ru.yandex.common.uatraits;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;

public class Uatraits {
    private static final String LIBNAME = "uatraits";

    static {
        try {
            loadLibrary();
        } catch (IOException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
    }

    private long self;

    public Uatraits() {
        this(create());
    }

    public Uatraits(String profilesConfig, String extrasConfig) throws InitializationException {
        this(create(profilesConfig, extrasConfig));
    }

    public Map<String, String> classify(String userAgent) {
        final String[] classify = classify(self, userAgent);
        final int len = classify.length / 2;
        final LinkedHashMap<String, String> result = new LinkedHashMap<>(len);
        for (int i = 0; i < len; i++) {
            result.put(classify[i], classify[i + len]);
        }
        return result;
    }

    protected Uatraits(long self) {
        if (self == 0L) {
            throw new OutOfMemoryError("Failure allocating native heap memory");
        }
        this.self = self;
    }

    private static void loadLibrary() throws IOException {
        try {
            System.loadLibrary(LIBNAME);
            return;
        } catch (UnsatisfiedLinkError ignored) {
        }
        final String libFileName = System.mapLibraryName(LIBNAME);
        final File file;
        try (InputStream in = Uatraits.class.getClassLoader().getResourceAsStream(libFileName)) {
            if (in == null) {
                throw new IOException("Missing JNI library - " + libFileName);
            }
            final int pos = libFileName.lastIndexOf('.');
            file = File.createTempFile(libFileName.substring(0, pos), libFileName.substring(pos));
            file.deleteOnExit();
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(file.getAbsolutePath());
    }

    private static native long create();

    private static native long create(String profilesConfig, String extrasConfig) throws InitializationException;

    private static native void delete(long self);

    private native String[] classify(long self, final String userAgent);

    private void delete() {
        assert this.self != 0L : "Uatraits not loaded";
        delete(self);
        self = 0L;
    }

    protected void finalize() throws Throwable {
        delete();
        super.finalize();
    }
}
