#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <kernel/urlid/url2docid.h>

#include "ru_yandex_common_util_urlid_UrlId.h"


static jclass iaeClass;
static jclass eeeClass;

jint JNI_OnLoad(JavaVM *jvm, void *)
{
    JNIEnv *env;
    if (jvm->GetEnv((void**)&env, JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }

    iaeClass = (jclass)env->NewGlobalRef(env->FindClass("java/lang/IllegalArgumentException"));
    eeeClass = (jclass)env->NewGlobalRef(env->FindClass("java/lang/Error"));

    return JNI_VERSION_1_6;
}

JNIEXPORT void JNICALL Java_ru_yandex_common_util_urlid_UrlId_registerNatives(JNIEnv *, jclass)
{
    // do nothing
}

JNIEXPORT jstring JNICALL Java_ru_yandex_common_util_urlid_UrlId_urlIdToDocId(JNIEnv *env, jclass, jstring url, jstring lang)
{
    if (!url) {
        env->ThrowNew(iaeClass, "url is null");
        return nullptr;
    }

    const char* urlStr = env->GetStringUTFChars(url, nullptr);
    if (!urlStr) {
        env->ThrowNew(eeeClass, "Internal Error");
        return nullptr;
    }

    const char* langStr = lang != nullptr ? env->GetStringUTFChars(lang, nullptr) : nullptr;

    TString result = langStr != nullptr ? Url2DocIdSimple(urlStr, langStr) : Url2DocIdSimple(urlStr);

    env->ReleaseStringUTFChars(url, urlStr);
    if (langStr != nullptr) {
        env->ReleaseStringUTFChars(lang, langStr);
    }

    return env->NewStringUTF(result.c_str());
}

JNIEXPORT void JNICALL Java_ru_yandex_common_util_urlid_UrlId_destroy(JNIEnv *, jobject)
{
    // do nothing
}
