package ru.yandex.common.util;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import static org.hamcrest.core.AllOf.allOf;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsInstanceOf.instanceOf;
import static org.junit.internal.matchers.ThrowableMessageMatcher.hasMessage;
import static ru.yandex.common.util.urlid.UrlId.urlIdToDocId;

/**
 * @author imakunin
 */
public class UrlIdTest {

  @Rule
  public final ExpectedException thrown = ExpectedException.none();

  @Test
  public void test() {
    Assert.assertEquals("Z612A952099CD8FE2", urlIdToDocId("https://twitter.com/segalovich", null));
    Assert.assertEquals("Z3E9C56E652B9AD1F", urlIdToDocId("https://twitter.com/segalovich", "de"));
  }

  @Test
  public void testNull() {
    thrown.expect(allOf(
            instanceOf(IllegalArgumentException.class),
            hasMessage(equalTo("url is null")))
    );
    urlIdToDocId(null, null);
  }

}
