/* those should prepend Perl headers to avoid name clashes */
#include <apphost/lib/compression/compression.h>

#include <util/generic/yexception.h>

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif

/* Oldperl copypaste */
#if defined (_WIN64) || defined (_WIN32) || defined (__WIN32__)
#define EXCEPTION_MESSAGE "something bad happened"
#else
#define EXCEPTION_MESSAGE CurrentExceptionMessage().data()
#endif

using namespace NAppHost;
using namespace NCompression;

MODULE = Yx::AppHost::Compression         PACKAGE = Yx::AppHost::Compression

TString
Encode(TStringBuf data, int codecId)
    CODE:
        try {
            RETVAL = Encode(data, codecId);
        }
        catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL

TString
Decode(TStringBuf data)
    CODE:
        try {
            RETVAL = Decode(data);
        }
        catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL

