#include <yweb/config/clustercfg.h>

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif

static ClusterConfig ClusterCfg;

MODULE = Yandex::ClusterConfig             PACKAGE = Yandex::ClusterConfig

int
LoadFromConfig(hostcfg = "/Berkanavt/database/host.cfg")
    const char *hostcfg
    CODE:
    RETVAL = 0;
    try {
        ClusterCfg.LoadFromConfig(hostcfg);
    } catch (...) {
        RETVAL = 1;
    }
    OUTPUT:
    RETVAL

int
LoadSegmentConfig(seg, hostcfg = "/Berkanavt/database/host.cfg")
    const char *seg
    const char *hostcfg
    CODE:
    RETVAL = 0;
    try {
        ClusterCfg.LoadFromConfig(hostcfg, seg);
    } catch (...) {
        RETVAL = 1;
    }
    OUTPUT:
    RETVAL

int
Cluster2Handle(c, h)
    int c
    int h
    CODE:
    ui32 d;
    ClusterCfg.Cluster2Handle(d, c, h);
    RETVAL = d;
    OUTPUT:
    RETVAL

int
Handle2Clnum(d)
    int d
    CODE:
    ui32 c, h;
    ClusterCfg.Handle2Cluster(d, c, h);
    RETVAL = c;
    OUTPUT:
    RETVAL

int
Handle2Chandle(d)
    int d
    CODE:
    ui32 c, h;
    ClusterCfg.Handle2Cluster(d, c, h);
    RETVAL = h;
    OUTPUT:
    RETVAL
