/* those should prepend Perl headers to avoid name clashes */
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/ptr.h>
#include <util/generic/yexception.h>
#include <util/network/socket.h>

#include <kernel/catfilter/catfilter_wrapper.h>
#include <kernel/mirrors/mirrors_trie.h>

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif


MODULE = Yx::Filter         PACKAGE = Yx::Filter

ICatFilter*
new(package, filename, mirrors = NULL)
    const char *package;
    const char *filename;
    TMirrorsMappedTrie *mirrors;
    CODE:
        try {
            RETVAL = GetCatFilter(filename, true, mirrors);
        } catch (...) {
            croak("Failed to load filter");
        }
    OUTPUT:
        RETVAL

MODULE = Yx::Filter         PACKAGE = ICatFilterPtr

unsigned int
get(self, url)
    ICatFilter *self;
    const char *url;
    PPCODE:
        TCatAttrsPtr cats = self->Find(url);
        int no = cats->size();
        if (no) {
            EXTEND(SP, no);
            for (TCatAttrs::const_iterator it = cats->begin(); it != cats->end(); it++)
                PUSHs(sv_2mortal(newSViv(*it)));
        }

void
ICatFilter::DESTROY()
