package Matrixnet;

use strict;

require DynaLoader;
require AutoLoader;

our @ISA = qw(Exporter AutoLoader DynaLoader);

bootstrap Matrixnet;
__END__

=head1 NAME

Matrixnet -  Perl interface to Yandex Matrixnet model calculation

=head1 SYNOPSIS

  use Matrixnet;
  use Data::Dumper;
  my $matrixnet = Matrixnet->new("matrixnet.info");

  print Dumper($matrixnet->calculate([1, 2, 3, 4]));
  #    $VAR1 = '0.807296914341013';
  #
  print Dumper($matrixnet->calculate_list([[1, 2, 3, 4], [5,6,7,8]]));
  #    $VAR1 = [
  #        '0.807296914341013',
  #        '0.836158117271234'
  #    ];

=cut

1;
