/* those should prepend Perl headers to avoid name clashes */
#include <util/stream/file.h>
#include <util/ysaveload.h>
#include <kernel/matrixnet/mn_dynamic.h>
#include <util/system/filemap.h>

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif

typedef NMatrixnet::TMnSseDynamic TMXInfo;

MODULE = Matrixnet        PACKAGE = Matrixnet



TMXInfo *
new(package, filename)
    const char *package;
    const char *filename;
    CODE:
        try {
            TString path(filename);
            TFileInput in(path);
            TMXInfo * mx = new TMXInfo;
            ::Load(&in, *mx);

            RETVAL = mx;
        }
        catch (...) {
            croak("Failed to init Matrixnet");
        }
    OUTPUT:
        RETVAL

MODULE = Matrixnet        PACKAGE = TMXInfoPtr

double
calculate(self, params)
    TMXInfo * self;
    AV * params;
    CODE:
        int i;
        int factors_count = av_len(params) + 1;
        TVector< TVector<float> > factors(1);
        TVector<double> result(1);
        factors[0].resize(factors_count);
        for (i = 0; i < factors_count ; i++) {
            SV** elem = av_fetch(params, i, 0);
            if (elem != NULL)
                factors[0][i] = SvNV(*elem);
        }
        self->CalcRelevs(factors, result);
        RETVAL = result[0];
    OUTPUT:
        RETVAL

AV *
calculate_list(self, rows)
    TMXInfo * self;
    AV * rows;
    CODE:
        SSize_t rows_count = av_len(rows) + 1;
        TVector< TVector<float> > factors(rows_count);
        TVector<double> result(rows_count);
        for (int row = 0; row < rows_count; ++row) {
            SV ** ar = av_fetch(rows, row, 0);
            AV * params;
            if (!ar || !SvROK(*ar) || SvTYPE(params = (AV *)SvRV(*ar)) != SVt_PVAV)
                croak("bad element in rows list (not a list)");
            int factors_count = av_len(params) + 1;
            TVector<float> & row_factors = factors[row];
            for (int i = 0; i < factors_count ; i++) {
                SV** elem = av_fetch(params, i, 0);
                if (elem != NULL) {
                    row_factors.push_back(SvNV(*elem));
                } else {
                    warn("use zero factor instead of null element");
                    row_factors.push_back(0);
                }
            }
        }
        self->CalcRelevs(factors, result);
        AV * rv = newAV();
        for (int row = 0; row < rows_count; ++row) {
            av_push(rv, newSVnv(result[row]));
        }
        RETVAL = rv;
    OUTPUT:
        RETVAL

void
TMXInfo::DESTROY()
    CODE:
        delete THIS;

