/* those should prepend Perl headers to avoid name clashes */
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/ptr.h>
#include <util/generic/yexception.h>
#include <util/network/socket.h>

#include <kernel/mirrors/mirrors_trie.h>

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif

MODULE = Yx::Mirrors        PACKAGE = Yx::Mirrors

TMirrorsMappedTrie*
new(package, filename)
    const char *package;
    const char *filename;
    CODE:
        try {
            RETVAL = new TMirrorsMappedTrie(filename, 0);
        }
        catch (...) {
            croak("Failed to init Yx::Mirrors");
        }
    OUTPUT:
        RETVAL

MODULE = Yx::Mirrors        PACKAGE = TMirrorsMappedTriePtr

const char*
main(self, url)
    TMirrorsMappedTrie *self;
    const char* url;
    CODE:
        TString buf;
        if (!self->GetCheck(url, buf).empty()) {
            RETVAL = buf.c_str();
        }
        else {
            RETVAL = url;
        }
    OUTPUT:
        RETVAL

void
group(self, url, exclude_redirects = false)
    TMirrorsMappedTrie *self;
    const char *url;
    bool exclude_redirects;
    PPCODE:
        TMirrorsMappedTrie::THostId hostId = self->StringToId(url);

        if (!self->IsValidHostId(hostId)) {
            XSRETURN_PV(url);
        }

        TMirrorsMappedTrie::TGroup group = self->GetGroup(hostId);
        if (group.GetSize()) {
            for (unsigned int i = 0; i < group.GetSize(); i++) {
                TMirrorsMappedTrie::THostId hostId = group[i];
                if (!exclude_redirects) { // || !self->IsLink(hostId)) {
                    TString buf;
                    if (self->IdToString(hostId, buf) != NULL) {
                        XPUSHs(sv_2mortal(newSVpv(buf.c_str(), 0)));
                    }
                }
            }
        }

void
TMirrorsMappedTrie::DESTROY()
