#!/usr/bin/perl -w
use lib '.';
#use Yabs::OnlineXFactor;
use OnlineXFactor;

my @txt = (
	'купите блок хаус в уфе',
);

my $x = new Yabs::OnlineXFactor::Reader("$ENV{HOME}/OXF/indexoxf.");

my $p = new Yabs::OnlineXFactor::Params();

$p->SetTimeoutMilliseconds(4);
$p->SetMaxCands(13);
$p->SetMaxMatches(5);
$p->SetQuorumLevel(0.995);
$p->SetMaxDecay(500);
$p->SetSmartOpts(1);
$p->SetOutQuorumLevel(2.0);
$p->SetMinCount(2);

print "\nOnly ReqBundle\n";

foreach (@txt) {
	print "---\n$_\n---\n";

	my $candidates = $x->FindCandidates($_, $p);

	if (!$candidates) {
		print "no candidates\n";
		next;
	}

	for my $c (@$candidates) {
		print $c->[0], ' --- ', $c->[1], "\n";
	}
}

$p->SetSmartOpts(3);

print "\nReqBundle + IndexQI\n";

foreach (@txt) {
	print "---\n$_\n---\n";

	my $candidates = $x->FindCandidates($_, $p);

	if (!$candidates) {
		print "no candidates\n";
		next;
	}

	for my $c (@$candidates) {
		print $c->[0], ' --- ', $c->[1], "\n";
	}
}

$p->SetSmartOpts(11);

print "\nReqBundle + IndexQI + SmartMatch\n";

foreach (@txt) {
	print "---\n$_\n---\n";

	my $candidates = $x->FindCandidates($_, $p);

	if (!$candidates) {
		print "no candidates\n";
		next;
	}

	for my $c (@$candidates) {
		print $c->[0], ' --- ', $c->[1], "\n";
	}
}

$p->SetSmartOpts(11);
$p->SetMinCount(1);

print "\nReqBundle + IndexQI + SmartMatch\n";

foreach (@txt) {
	print "---\n$_\n---\n";

	my $candidates = $x->FindCandidates($_, $p);

	if (!$candidates) {
		print "no candidates\n";
		next;
	}

	for my $c (@$candidates) {
		print $c->[0], ' --- ', $c->[1], "\n";
	}
}
