/* those should prepend Perl headers to avoid name clashes */
#include <ads/quality/user_targeting_xfactor/lib/reader/oxf_reader.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

typedef NDirect::TOnlineXFactorReader TOnlineXFactorReader;


MODULE = Yabs::OnlineXFactor     PACKAGE = Yabs::OnlineXFactor::Params


TFindCandParams*
new(package)
    CODE:
        try {
            RETVAL = new TFindCandParams();
        }
        catch (...) {
            croak("Failed to init TFindCandParams");
        }
    OUTPUT:
        RETVAL


MODULE = Yabs::OnlineXFactor     PACKAGE = TFindCandParamsPtr


void
SetTimeoutMilliseconds(self, timeoutMilliseconds)
    TFindCandParams* self;
    unsigned int timeoutMilliseconds;
    CODE:
        self->TimeoutMilliseconds = timeoutMilliseconds;

void
SetMaxCands(self, maxCands)
    TFindCandParams* self;
    unsigned int maxCands;
    CODE:
        self->MaxCands = maxCands;

void
SetMaxMatches(self, maxMatches)
    TFindCandParams* self;
    unsigned int maxMatches;
    CODE:
        self->MaxMatches = maxMatches;

void
SetQuorumLevel(self, quorumLevel)
    TFindCandParams* self;
    float quorumLevel;
    CODE:
        self->QuorumLevel = quorumLevel;

void
SetMaxDecay(self, maxDecay)
    TFindCandParams* self;
    unsigned int maxDecay;
    CODE:
        self->MaxDecay = maxDecay;

void
SetReqBundle(self, reqBundle)
    TFindCandParams* self;
    unsigned int reqBundle;
    CODE:
        self->SmartOpts = reqBundle;

void
SetSmartOpts(self, smartOpts)
    TFindCandParams* self;
    unsigned int smartOpts;
    CODE:
        self->SmartOpts = smartOpts;

void
SetOutQuorumLevel(self, outQuorumLevel)
    TFindCandParams* self;
    float outQuorumLevel;
    CODE:
        self->OutQuorumLevel = outQuorumLevel;

void
SetMinCount(self, minCount)
    TFindCandParams* self;
    unsigned int minCount;
    CODE:
        self->MinCount = minCount;

void
SetIndexName(self, indexName)
    TFindCandParams* self;
    const char* indexName;
    CODE:
        TString index(indexName);
        self->IndexName = index;

void
DESTROY(self)
    TFindCandParams* self;
    CODE:
        delete self;


MODULE = Yabs::OnlineXFactor     PACKAGE = Yabs::OnlineXFactor::Reader


TOnlineXFactorReader*
new(package, indexDir)
    const char* indexDir;
    CODE:
        try {
            RETVAL = new TOnlineXFactorReader(indexDir);
        }
        catch (const yexception &e) {
            croak(e.what());
        }
        catch (...) {
            croak("Exception in TOnlineXFactorReader constructor");
        }
    OUTPUT:
        RETVAL


MODULE = Yabs::OnlineXFactor       PACKAGE = TOnlineXFactorReaderPtr


SV *
FindCandidates(self, phrase, findParams)
    TOnlineXFactorReader* self;
    const char* phrase;
    TFindCandParams* findParams;
    CODE:
        try {
            TVector<NDirect::TOnlineXFactorCandidate> candidates;
            self->FindCandidates(phrase, candidates, *findParams);
            if (candidates.empty()) {
                XSRETURN_UNDEF;
            }
            AV * results = (AV *)sv_2mortal((SV *)newAV());
            av_extend(results, candidates.size());
            for (const auto& i : candidates) {
                AV * pair = (AV *)sv_2mortal((SV *)newAV());
                av_extend(pair, 2);
                av_push(pair, newSVpv(i.Phrase.data(), i.Phrase.size()));
                av_push(pair, newSVnv(i.Weight));
                av_push(results, newRV((SV *)pair));
            }

            RETVAL = newRV((SV *)results);
        }
        catch (const yexception &e) {
            croak(e.what());
        }
        catch (...) {
            croak("Exception in FindCandidates");
        }

    OUTPUT:
        RETVAL


void
DESTROY(self)
    TOnlineXFactorReader* self;
    CODE:
        delete self;
