package Yx::ReportBundle;

use strict;
use warnings;

use DynaLoader ();
use List::Util qw/ first /;

sub import {
    my ($pkg, $lib_filename) = @_;

    $lib_filename ||= first { -f $_ } map { "$_/upperapache2.perl5lib.so" } grep $_, ($ENV{UPPER_DIR} && "$ENV{UPPER_DIR}/bin"), $ENV{ROOT_DIR}, '/hol/arkanavt';

    die "Could not find upperapache2.perl5lib.so" unless $lib_filename;

    my $lib = DynaLoader::dl_load_file($lib_filename)
        or die "DL load error ($lib_filename): ".DynaLoader::dl_error;

    for my $symbol (map { s/.*\s//; $_ } grep / boot_/, split /\s*\n\s*/, `nm $lib_filename`) {
        my $bootstrap = DynaLoader::dl_find_symbol($lib, $symbol) or die "DL find error: ".DynaLoader::dl_error;

        my $pkg = $symbol;

        $pkg =~ s/boot_//;
        $pkg =~ s/__/::/g;

        if ($pkg =~ /^Encode::/) {
            require Encode;
        }

        my $bootstrap_name = $pkg . '::bootstrap';

        DynaLoader::dl_install_xsub($bootstrap_name, $bootstrap)
            or die "DL install error: ".DynaLoader::dl_error;

        eval "$bootstrap_name();" or die "bootstrap error: $@";
    }
}

1
