#!/usr/bin/env python
#-*- coding: utf-8 -*-

import optparse


INIT_SIGNATURE = 'void InitInternalPerlModulesNG(PerlInterpreter *i, const char *filename)';
REGISTER_SIGNATURE = 'void RegisterPerlXS(PerlInterpreter *i, char *name, void (*bootstrap)(pTHX_ CV* cv), const char *filename)';
IFDEF_HEADER = \
"""
#ifdef __cplusplus
    extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
    }
#endif
"""


def to_c(name):
    name = name.replace("::", "__")
    return name

if __name__ == "__main__":
    parser = optparse.OptionParser()
    (opts, args) = parser.parse_args()

    cppPath = args[0]
    hPath = args[1]
    modules = args[2:]

    with open(cppPath, 'w') as cpp:
        cpp.write('#include "require.h"\n\n')

        modules_arr = []
        for module in modules:
            modules_arr.append('extern "C" void boot_{m}(pTHX_ CV* cv);'.format(m=to_c(module)))
        cpp.write("\n".join(modules_arr) + "\n\n")

        cpp.write(REGISTER_SIGNATURE + """ {
    if (!get_cv(name, 0)) {
        Perl_newXS(i, name, bootstrap, (char *)filename);
    }
}

""")

        cpp.write(INIT_SIGNATURE + ' {\n')
        for module in modules:
            bootstrap = module + '::bootstrap'
            bootstrap_func = 'boot_' + to_c(module)
            cpp.write('    RegisterPerlXS(i, "{bp}", {bp_f}, filename);\n'.format(bp=bootstrap,
                    bp_f=bootstrap_func,
                    ))
        cpp.write("\n}\n")

    with open(hPath, 'w') as h:
        h.write(IFDEF_HEADER + "\n")
        h.write(REGISTER_SIGNATURE + ";\n")
        h.write(INIT_SIGNATURE + ";\n")

