LIBRARY(ReportBundle)

OWNER(ezhi)

NO_WERROR()

ENABLE(USE_PERL)

IF (NOT OS_WINDOWS)
    ADD_PERL_MODULE(
        contrib/libs/authparser/perl
        authparser
    )
    ADD_PERL_MODULE(
        metrika/uatraits/perl
        uatraits
    )
ENDIF()

ADD_PERL_MODULE(
    bindings/perl/guid
    Yx::GUID
)

ADD_PERL_MODULE(
    bindings/perl/requester
    Yx::Requester
)

ADD_PERL_MODULE(
    bindings/perl/simplelemmer
    SimpleLemmer
)

ADD_PERL_MODULE(
    bindings/perl/signurl
    SignUrl
)

ADD_PERL_MODULE(
    bindings/perl/metaproto
    NMetaProtocol::TReport
)

ADD_PERL_MODULE(
    bindings/perl/apphostproto
    NMetaProtocol::NAppHost::TResponse
)

ADD_PERL_MODULE(
    bindings/perl/apphostserviceproto
    NAppHostProtocol::TServiceRequest
)

ADD_PERL_MODULE(
    bindings/perl/apphostserviceproto
    NAppHostProtocol::TServiceResponse
)

ADD_PERL_MODULE(
    bindings/perl/apphostserviceproto
    NAppHostProtocol::TAnswer
)

ADD_PERL_MODULE(
    bindings/perl/apphostserviceproto
    NAppHostProtocol::TMetaFlag
)

ADD_PERL_MODULE(
    bindings/perl/app_host_compression
    Yx::AppHost::Compression
)

ADD_PERL_MODULE(
    yweb/webutil/perlhilitestr
    HiliteStr
)

ADD_PERL_MODULE(
    yweb/webutil/perlrequesttree
    Yx::Request::Tree
)

ADD_PERL_MODULE(
    bindings/perl/yson
    yson
)

IF (JUSTAPACHE)
    CFLAGS(-DJUSTAPACHE)
ENDIF()

# TODO: Add OUTPUT_INCLUDES
PYTHON(
    "${ARCADIA_ROOT}/bindings/perl/report-bundle/require.py" require.cpp require.h ${modules}
    OUT require.cpp require.h
)

SRCS(
    yand_perl_init.cpp
)

PEERDIR(
    contrib/libs/pcre
)

END()
