/* those should prepend Perl headers to avoid name clashes */
#include <search/session/requester/thread_context.h>
#include <search/session/requester/requester.h>
#include <search/session/requester/host_params.h>
#include <search/session/scfactory.h>
#include <search/idl/events.ev.pb.h>

#include <library/cpp/eventlog/eventlog.h>
#include <library/cpp/eventlog/threaded_eventlog.h>
#include <library/cpp/dns/cache.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/ptr.h>
#include <util/generic/yexception.h>
#include <util/network/socket.h>
#include <util/memory/blob.h>

#include <sys/types.h>
#include <unistd.h>

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif

/* Oldperl copypaste */
#undef Zero
#undef Copy
#undef Move
#undef New
#undef vwarn

/* Oldperl copypaste */
#if defined (_WIN64) || defined (_WIN32) || defined (__WIN32__)
#define EXCEPTION_MESSAGE "reqid range exception"
#else
#define EXCEPTION_MESSAGE CurrentExceptionMessage().data()
#endif

typedef TRemoteRequester YxRemoteRequester;
typedef IRemoteRequestResult YxRemoteRequestResult;

MODULE = Yx::Requester         PACKAGE = Yx::DNSCache

void
add(hosts)
    char* hosts
    CODE:
        TStringBuf buf(hosts, strlen(hosts)), hostAndIp, host, ip;
        while(!buf.empty()) {
            hostAndIp = buf.NextTok(' ');
            hostAndIp.Split('=', host, ip);
            NDns::AddHostAlias(TString{host}, TString{ip});
        }

MODULE = Yx::Requester         PACKAGE = Yx::ThreadedEventLog

TThreadedEventLog*
new(eventLog)
    TEventLog* eventLog
    CODE:
        try {
            AtomicAdd(eventlogFrameCounter, getpid() << 16);
            RETVAL = new TThreadedEventLog(eventLog);
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL

MODULE = Yx::Requester         PACKAGE = TThreadedEventLogPtr

void
TThreadedEventLog::DESTROY()

void
TThreadedEventLog::ReopenLog()

void
TThreadedEventLog::LogMessage(reqid, facility, msg)
    const char *reqid
    const char *facility
    const char *msg
    CODE:
        try {
            THIS->LogEvent(
                NEvClass::TReportMessage(
                    reqid,
                    facility,
                    msg
                )
            );
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }

void
TThreadedEventLog::LogError(reqid, facility, msg)
    const char *reqid
    const char *facility
    const char *msg
    CODE:
        try {
            THIS->LogEvent(
                NEvClass::TReportError(
                    reqid,
                    facility,
                    msg
                )
            );
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }


MODULE = Yx::Requester         PACKAGE = Yx::EventLog

TEventLog*
new(path)
    const char* path
    CODE:
        try {
            RETVAL = new TEventLog(path, NEvClass::Factory()->CurrentFormat());
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL


MODULE = Yx::Requester         PACKAGE = TEventLogPtr

void
TEventLog::ReopenLog()

void
TEventLog::LogMessage(reqid, facility, msg)
    const char *reqid
    const char *facility
    const char *msg
    CODE:
        try {
            THIS->LogEvent(
                NEvClass::TReportMessage(
                    reqid,
                    facility,
                    msg
                )
            );
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }

void
TEventLog::LogError(reqid, facility, msg)
    const char *reqid
    const char *facility
    const char *msg
    CODE:
        try {
            THIS->LogEvent(
                NEvClass::TReportError(
                    reqid,
                    facility,
                    msg
                )
            );
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }

# void
# TEventLog::DESTROY()

MODULE = Yx::Requester         PACKAGE = Yx::ThreadContext

ISearchThreadContext*
new(eventLog=NULL, numThreads=4)
    int numThreads
    TEventLog* eventLog
    CODE:
        try {
            RETVAL = new TSearchThreadContext(eventLog, numThreads);
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL

ISearchThreadContext*
newT(eventLog=NULL, numThreads=4)
    int numThreads
    TThreadedEventLog* eventLog
    CODE:
        try {
            RETVAL = new TSearchThreadContext(eventLog, numThreads);
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL

ISearchThreadContext*
context_with_eventlog(name, numThreads=4)
    const char* name
    int numThreads
    CODE:
        try {
            RETVAL = new TSearchThreadContext(name, numThreads);
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL


MODULE = Yx::Requester         PACKAGE = ISearchThreadContextPtr

# TODO: watch for memory leaks (TSearchThreadContext definetly leaks)
void
ISearchThreadContext::DESTROY()


MODULE = Yx::Requester         PACKAGE = Yx::RequesterConfig

TTreeRequestParamsPtr*
requester_params_from_json(json_str)
    const char* json_str
    CODE:
        try {
            RETVAL = new TTreeRequestParamsPtr(TTreeRequestParams::FromJson(json_str));
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL


void
TTreeRequestParamsPtr::DESTROY()


# debug
void
print_params(p)
    TTreeRequestParamsPtr* p
    CODE:
        printf("TTreeRequestParams\n");
        if (!p) {
            printf("  NULL\n");
        } else {
            printf("  Delays size: %lu\n", (*p)->GetDelays().size());
            printf("  Timeout (ms): %lu\n", (*p)->GetTimeout().MilliSeconds());
            printf("  HostSelectionPolicy: %s\n", (*p)->GetHostSelectionPolicy().c_str());
            printf("  Requests: %lu\n", (*p)->GetRequestsCount());

            for (const auto& host: ((*p)->GetHosts()).GetNodes()) {
                if (host.IsLeaf()) {
                    printf("  Host: %s Port %lu\n", host.GetValue().GetHost().c_str(), host.GetValue().GetPort());
                }
                else {
                    for (const auto& host2: host.GetNodes()) {
                        if (host2.IsLeaf()) {
                            printf("  Host: %s Port %lu\n", host2.GetValue().GetHost().c_str(), host2.GetValue().GetPort());
                        }
                    }
                }
            }
        }

AV*
all_host_port(p)
    TTreeRequestParamsPtr* p

    CODE:
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        for (const auto& host: ((*p)->GetHosts()).GetNodes()) {
            TStringStream buf;
            if (host.IsLeaf()) {
                buf << host.GetValue().GetHost() << ":" << host.GetValue().GetPort();
                av_push(RETVAL, newSVpv(buf.Str().c_str(), buf.Str().size()));
            }
            else {
                for (const auto& host2: host.GetNodes()) {
                    if (host2.IsLeaf()) {
                        buf << host2.GetValue().GetHost() << ":" << host2.GetValue().GetPort();
                        av_push(RETVAL, newSVpv(buf.Str().c_str(), buf.Str().size()));
                    }
                }
            }
        }
    OUTPUT:
        RETVAL

MODULE = Yx::Requester         PACKAGE = Yx::RemoteRequester


YxRemoteRequester*
new(klass, context, reqid)
    const char* klass
    ISearchThreadContext* context
    const char* reqid

    CODE:
        try {
            RETVAL = new YxRemoteRequester(context, reqid, context->SpawnLogFrame());
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL


MODULE = Yx::Requester         PACKAGE = YxRemoteRequesterPtr


void
YxRemoteRequester::DESTROY()


void
YxRemoteRequester::SetReconnectTimeout(timeout)
    size_t timeout


int
YxRemoteRequester::AddRequestUrl(url, timeout)
    const char* url
    size_t timeout

int
YxRemoteRequester::AddRequest(host, port, path, timeout)
    const char* host
    ui16 port
    const char* path
    size_t timeout

#TODO: const params
int
YxRemoteRequester::AddMultiRequest(params, path)
    TTreeRequestParamsPtr* params
    const char* path

    CODE:
        try {
            RETVAL = THIS->AddMultiRequest(*params, path);
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL

void
YxRemoteRequester::AddRequestHeader(index, name, value)
    int index
    const char* name
    const char* value

void
YxRemoteRequester::SetRequestBody(index, body)
    int index
    SV* body
    CODE:
        try {
            TString data;
            STRLEN len = 0;

            if (SvUTF8(body)) {
                len = sv_len_utf8(body);
                data = (char*)SvPVutf8(body, len);
            } else {
                char* d = (char*)SvPV(body, len);
                data = TString(d, len);
            }

            TBlob blob = TBlob::Copy(data.c_str(), len);

            THIS->SetRequestBody(index, blob);
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        body

#Copy paste from oldperl
IRemoteRequestResult*
YxRemoteRequester::GetRequestResult(index)
    int index
    CODE:
        try {
            RETVAL = (YxRemoteRequestResult*)(THIS->GetRequestResult(index));
        } catch (...) {
            croak(EXCEPTION_MESSAGE);
        }
    OUTPUT:
        RETVAL

bool
YxRemoteRequester::NeedWaitAll()

void
YxRemoteRequester::SetNeedWaitAll(val)
    bool val

void
YxRemoteRequester::Start()

void
YxRemoteRequester::Join()

void
YxRemoteRequester::SetRequestHash(index, h)
    int index
    TRequestHash h

void
YxRemoteRequester::SetDescription(index, description)
    int index
    char* description

TString
YxRemoteRequester::GetEvents()

bool
YxRemoteRequester::Only2xxIsSuccess()

void
YxRemoteRequester::SetOnly2xxIsSuccess(val)
    bool val

#Copy-paste of oldperl
MODULE = Yx::Requester PACKAGE = IRemoteRequestResultPtr

size_t
IRemoteRequestResult::StatusCode()

size_t
IRemoteRequestResult::HeaderCount()

const char*
IRemoteRequestResult::HeaderName(index)
    size_t index

const char*
IRemoteRequestResult::HeaderValueByIndex(index)
    size_t index

const char*
IRemoteRequestResult::HeaderValue(headerName)
    const char* headerName

TSimpleBlob
IRemoteRequestResult::Content()

