#!/usr/bin/env perl

use strict;
use warnings;
use Requester;

Yx::DNSCache::add("xxx=1.1.1.1");
my $e = Yx::EventLog::new('eventlog.N');
my $c = Yx::ThreadContext::new($e, 1);
$e->ReopenLog();

my $json_params = <<EOF;
{
    "Hosts" : "xxx:1 localhost:2\@20",
    "Delays" : "0 35ms",
    "TimeoutMilliseconds" : 100,
    "ReconnectTimeoutMilliseconds" : 70,
    "HostSelectionPolicy": "hh",
    "RequestsCount" : 2
}
EOF

my $p = Yx::RequesterConfig::requester_params_from_json($json_params);
Yx::RequesterConfig::print_params($p);

my $r = Yx::RemoteRequester->new($c, "test.pl");
$r->SetReconnectTimeout(77);
my @idxs;
push @idxs, $r->AddRequestUrl("margarita.yandex.ru:10157/", 100000);
push @idxs, $r->AddMultiRequest($p, 100000);
$r->SetDescription($idxs[$#idxs], "custom description");

$r->Start();
print "index is @idxs\n";
$r->Join();

for my $idx (grep { $_ >= 0 } @idxs) {
    print "result for $idx\n";
    my $result = $r->GetRequestResult($idx);
    if ($result) {
        my $code = $result->StatusCode();
        print "  status: $code\n";
    } else {
        print "  no answer\n";
    }
}

print $r->GetEvents();
$r = undef;
$c = undef;
$e = undef;

print "That's all, folks!\n";
exit 0;

