package Yx::RobotFilter;

use strict;

require DynaLoader;
require Exporter;

our @ISA = qw(Exporter DynaLoader);

our %EXPORT_TAGS = (
        subs => [ qw{
            FilterReject
            FilterReject2
            FilterRejectHost
            FilterLoad
            isGoodExtension
            FilterSwap
        } ],
        const => [ qw{
            UrlFilterOK               
            UrlFilterEmpty            
            UrlFilterOpaque           
            UrlFilterBadFormat        
            UrlFilterBadPath          
            UrlFilterTooLong          
            UrlFilterBadPort          
            UrlFilterBadAuth          
            UrlFilterBadScheme        
            UrlFilterHost             
            UrlFilterUrl              
            UrlFilterSuffix           
            UrlFilterDomain           
            UrlFilterExtDomain        
            UrlFilterPort             
            UrlFilterMax              
            URL_PARSE_EMPTY           
            URL_PARSE_SCHEME          
            URL_PARSE_FORMAT          
            URL_PARSE_PORT            
            URL_PARSE_PATH            
            URL_PARSE_SCHEME2         
            URL_PARSE_AUTH            
            URL_PARSE_LENGTH          
            URL_PARSE_HOSTFILTER      
            URL_PARSE_URLFILTER       
            URL_PARSE_SUFFIXFILTER    
            URL_PARSE_DOMAINFILTER    
            URL_PARSE_EXTDOMAINFILTER 
            URL_PARSE_PORTFILTER      
            URL_PARSE_MAX             
        } ],
        all => [
        ],
);
our @EXPORT_OK;

{
    my %seen;
    foreach $_ (qw(subs const)) {
        push(@{$EXPORT_TAGS{all}}, grep {!$seen{$_}++} @{$EXPORT_TAGS{$_}})
    }
    push(@EXPORT_OK, keys %seen);
}


bootstrap Yx::RobotFilter;

1
