/* those should prepend Perl headers to avoid name clashes */
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/ptr.h>
#include <util/generic/yexception.h>
#include <util/network/socket.h>


#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif

#include <yweb/urlfilter/urlfilter.h>
#include <yweb/robot/dbscheeme/urlflags.h>

MODULE = Yx::RobotFilter         PACKAGE = Yx::RobotFilter

int
FilterReject(Url)
    const char *Url;
    CODE:
        RETVAL = FilterReject(Url);
    OUTPUT:
        RETVAL

int
FilterReject2(Host, Path)
    const char *Host;
    const char *Path;
    CODE:
        RETVAL = FilterReject2(Host, Path);
    OUTPUT:
        RETVAL

int
FilterRejectHost(Host)
    const char *Host;
    CODE:
        RETVAL = FilterRejectHost(Host);
    OUTPUT:
        RETVAL

int
FilterLoad(fname)
    const char *fname;
    CODE:
        RETVAL = FilterLoad(fname);
    OUTPUT:
        RETVAL

int
isGoodExtension(path)
    const char *path;
    CODE:
        RETVAL = isGoodExtension(path);
    OUTPUT:
        RETVAL

void
FilterSwap()
    CODE:
        FilterSwap();

int
constant()
    ALIAS:
        UrlFilterOK                 = 1
        UrlFilterEmpty              = 2
        UrlFilterOpaque             = 3
        UrlFilterBadFormat          = 4
        UrlFilterBadPath            = 5
        UrlFilterTooLong            = 6
        UrlFilterBadPort            = 7
        UrlFilterBadAuth            = 8
        UrlFilterBadScheme          = 9
        UrlFilterHost               = 10
        UrlFilterUrl                = 11
        UrlFilterSuffix             = 12
        UrlFilterDomain             = 13
        UrlFilterExtDomain          = 14
        UrlFilterPort               = 15
        UrlFilterMax                = 16
        URL_PARSE_EMPTY             = 17
        URL_PARSE_SCHEME            = 18
        URL_PARSE_FORMAT            = 19
        URL_PARSE_PORT              = 20
        URL_PARSE_PATH              = 21
        URL_PARSE_SCHEME2           = 22
        URL_PARSE_AUTH              = 23
        URL_PARSE_LENGTH            = 24
        URL_PARSE_HOSTFILTER        = 25
        URL_PARSE_URLFILTER         = 26
        URL_PARSE_SUFFIXFILTER      = 27
        URL_PARSE_DOMAINFILTER      = 28
        URL_PARSE_EXTDOMAINFILTER   = 29
        URL_PARSE_PORTFILTER        = 30
        URL_PARSE_MAX               = 31

    PREINIT:
        static const int values [32] = {
            0, // never used
            UrlFilterOK,        // UrlFilterOK
            UrlFilterEmpty,     // UrlFilterEmpty
            UrlFilterOpaque,    // UrlFilterOpaque
            UrlFilterBadFormat, // UrlFilterBadFormat
            UrlFilterBadPath,   // UrlFilterBadPath
            UrlFilterTooLong,   // UrlFilterTooLong
            UrlFilterBadPort,   // UrlFilterBadPort
            UrlFilterBadAuth,   // UrlFilterBadAuth
            UrlFilterBadScheme, // UrlFilterBadScheme
            UrlFilterHost,      // UrlFilterHost
            UrlFilterUrl,       // UrlFilterUrl
            UrlFilterSuffix,    // UrlFilterSuffix
            UrlFilterDomain,    // UrlFilterDomain
            UrlFilterExtDomain, // UrlFilterExtDomain
            UrlFilterPort,      // UrlFilterPort
            UrlFilterMax,       // UrlFilterMax
            // from filter_test.cpp
            UrlFilterEmpty,     // URL_PARSE_EMPTY  
            UrlFilterBadScheme, // URL_PARSE_SCHEME
            UrlFilterBadFormat, // URL_PARSE_FORMAT
            UrlFilterBadPort,   // URL_PARSE_PORT
            UrlFilterBadPath,   // URL_PARSE_PATH
            UrlFilterOpaque,    // URL_PARSE_SCHEME2 - should be another value for URL_PARSE_SCHEME
            UrlFilterBadAuth,   // URL_PARSE_AUTH
            UrlFilterTooLong,   // URL_PARSE_LENGTH
            UrlFilterHost,      // URL_PARSE_HOSTFILTER
            UrlFilterUrl,       // URL_PARSE_URLFILTER
            UrlFilterSuffix,    // URL_PARSE_SUFFIXFILTER
            UrlFilterDomain,    // URL_PARSE_DOMAINFILTER
            UrlFilterExtDomain, // URL_PARSE_EXTDOMAINFILTER
            UrlFilterPort,      // URL_PARSE_PORTFILTER
            UrlFilterMax        // URL_PARSE_MAX
        };
    CODE:
        if (!ix) {
            const char *name = GvNAME(CvGV(cv));
            croak("Unknown Yx::RobotFilter constant '%s'", name);
        }
        RETVAL = values[ix];
    OUTPUT:
        RETVAL
