/* those should prepend Perl headers to avoid name clashes */
#include <kernel/seinfo/seinfo.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

typedef NSe::TInfo TSeInfo;

MODULE = Yabs::SeInfo       PACKAGE = Yabs::SeInfo


TSeInfo*
new()
    CODE:
        try {
            RETVAL = new NSe::TInfo;
        }
        catch (const yexception &e) {
            croak(e.what());
            XSRETURN_UNDEF;
        }
        catch (...) {
            croak("Exception in GetSeInfo");
            XSRETURN_UNDEF;
        }
    OUTPUT:
        RETVAL


MODULE = Yabs::SeInfo       PACKAGE = TSeInfoPtr


bool
TSeInfo::ParseUrl(url)
    const char* url;
    CODE:
        try {
            TString s(url);
            NSe::GetSeInfo(url, *THIS);
            if (IsEmpty(*THIS)) {
                XSRETURN_UNDEF;
            } else {
                RETVAL = true;
            }
        }
        catch (const yexception &e) {
            croak(e.what());
            XSRETURN_UNDEF;
        }
        catch (...) {
            croak("Exception in GetSeInfo");
            XSRETURN_UNDEF;
        }

    OUTPUT:
        RETVAL


SV *
GetSearchFlagsDict()
    CODE:
        HV * rh;
        rh = (HV *) sv_2mortal ((SV *) newHV ());

        const auto& flagsDict = NSe::GetSearchFlagsDict();
        TVector<std::pair<NSe::ESearchFlags, TStringBuf>> names;
        flagsDict.GetAllNames(names);
        for (const auto& i : names) {
            hv_store(rh, i.second.data(), i.second.size(), newSVnv(i.first), 0);
        }
        RETVAL = newRV((SV *)rh);
    OUTPUT:
        RETVAL


bool
TSeInfo::IsEmpty()
    CODE:
        RETVAL = IsEmpty(*THIS);
    OUTPUT:
        RETVAL



bool
TSeInfo::IsSearch()
    CODE:
        RETVAL = THIS->IsSearch();
    OUTPUT:
        RETVAL


bool
TSeInfo::IsEmail()
    CODE:
        RETVAL = THIS->IsEmail();
    OUTPUT:
        RETVAL


bool
TSeInfo::IsSocial()
    CODE:
        RETVAL = THIS->IsSocial();
    OUTPUT:
        RETVAL



bool
TSeInfo::IsSerpAdv()
    CODE:
        RETVAL = THIS->IsSerpAdv();
    OUTPUT:
        RETVAL


bool
TSeInfo::IsWebAdv()
    CODE:
        RETVAL = THIS->IsWebAdv();
    OUTPUT:
        RETVAL


bool
TSeInfo::IsAdvert()
    CODE:
        RETVAL = THIS->IsAdvert();
    OUTPUT:
        RETVAL


bool
TSeInfo::IsWeb()
    CODE:
        RETVAL = THIS->IsWeb();
    OUTPUT:
        RETVAL


bool
TSeInfo::IsImage()
    CODE:
        RETVAL = THIS->IsImage();
    OUTPUT:
        RETVAL


bool
TSeInfo::IsLocal()
    CODE:
        RETVAL = THIS->IsLocal();
    OUTPUT:
        RETVAL


SV *
TSeInfo::EngineName()
    CODE:
        TString s(NSe::GetSearchEngineDict()[THIS->Name]);
        RETVAL = newSVpv(s.c_str(), s.size());
    OUTPUT:
        RETVAL


SV *
TSeInfo::Type()
    CODE:
        TString s(NSe::GetSearchTypeDict()[THIS->Type]);
        RETVAL = newSVpv(s.c_str(), s.size());
    OUTPUT:
        RETVAL


SV *
TSeInfo::Request()
    CODE:
        RETVAL = newSVpv(THIS->Query.c_str(), THIS->Query.size());
    OUTPUT:
        RETVAL


int
TSeInfo::Flags()
    CODE:
        RETVAL = THIS->Flags;
    OUTPUT:
        RETVAL


void
TSeInfo::DESTROY()
    CODE:
        delete THIS;

