/* those should prepend Perl headers to avoid name clashes */
#include <kernel/signurl/signurl.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

MODULE = SignUrl       PACKAGE = SignUrl
PROTOTYPES: ENABLE

SV*
Sign(url, key)
    char* url;
    char* key;
    CODE:
        size_t url_sz = SvCUR(ST(0));
        size_t key_sz = SvCUR(ST(1));
        if (url && url_sz && key && key_sz) {
            size_t res_sz = NSignUrl::SignSize();
            char* res = (char*)malloc(res_sz);
            if (res) {
                NSignUrl::Sign(url, url_sz, res, key, key_sz);
                SV* ret = newSVpvn(res, res_sz-1);
                free (res);
                RETVAL = ret;
            } else
                RETVAL = NULL;
        } else {
            RETVAL = NULL;
        }
    OUTPUT:
        RETVAL

size_t
Verify(sign, unsigned_txt, key)
    char* sign;
    char* unsigned_txt;
    char* key;
    CODE:
        size_t txt_sz = SvCUR(ST(1));
        size_t key_sz = SvCUR(ST(2));
        RETVAL = NSignUrl::Verify(sign, unsigned_txt, txt_sz, key, key_sz);
    OUTPUT:
        RETVAL


SV*
Crypt(url, key)
    char* url;
    char* key;
    CODE:
        size_t url_sz = SvCUR(ST(0));
        size_t key_sz = SvCUR(ST(1));
        if (url && url_sz && key && key_sz) {
            size_t res_sz = NSignUrl::CryptedSize(url_sz);
            char* res = (char*)malloc(url_sz);
            if (res) {
                size_t crypted_sz = NSignUrl::CryptBinary(url, url_sz, res, key, key_sz);
                if (crypted_sz != (size_t)res_sz) {
                    free(res);
                    RETVAL = NULL;
                } else {
                    SV* ret = newSVpvn(res, res_sz);
                    free(res);
                    RETVAL = ret;
                }
            } else {
                RETVAL = NULL;
            }
        } else {
            RETVAL = NULL;
        }
    OUTPUT:
    RETVAL

SV*
Decrypt(url, key)
    char* url;
    char* key;
    CODE:
        size_t url_sz = SvCUR(ST(0));
        size_t key_sz = SvCUR(ST(1));
        if (url && url_sz && key && key_sz) {
            char* res = (char*)malloc(url_sz);
            memset (res, '\0', url_sz);
            if (res) {
                size_t dec_sz = NSignUrl::Decrypt(url, url_sz, (char*)res, key, key_sz);
                if (dec_sz == 0) {
                    free(res);
                    RETVAL = NULL;
                } else {
                    SV* ret = newSVpvn(res, dec_sz);
                    free(res);
                    RETVAL = ret;
                }
            } else
                RETVAL = NULL;
        } else {
            RETVAL = NULL;
        }
    OUTPUT:
    RETVAL

