#!/usr/bin/perl -w

use lib '..';
use MIME::Base64;
use Test::More tests => 5;

require_ok('SignUrl');

my $k=pack("H16", "0123456789abcdef");

my $txt="/dtype=testsh*url=http://www.qq.com/&ts=1223540918&uid=1170514481214236046";
my $txt_cr = SignUrl::Crypt($txt, $k);
my $txt_decr = SignUrl::Decrypt($txt_cr, $k);

isnt($txt, $txt_cr, 'crypt crypts');
is($txt,  $txt_decr, 'crypt/decrypt');

my $sign = SignUrl::Sign($txt, $k);

ok(SignUrl::Verify($sign, $txt, $k), 'sign/verify correct');
ok(!SignUrl::Verify($sign, $txt."error", $k), 'sign/verify incorrect');
