/* those should prepend Perl headers to avoid name clashes */
#include <library/cpp/containers/comptrie/comptrie.h>
#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <util/datetime/base.h>
#include <util/memory/blob.h>

typedef TCompactTrie<char, TString> TStrStrTrie;

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif

MODULE = Yx::StrStrTrie        PACKAGE = Yx::StrStrTrie

TStrStrTrie*
new(package, filename)
    const char *package;
    const char *filename;
    CODE:
        try {
            TBlob filedata = TBlob::PrechargedFromFileSingleThreaded(filename);
            RETVAL = new TStrStrTrie(filedata);
        }
        catch (const TFileError& e) {
            croak("Failed to init Yx::StrStrTrie: %s", filename, e.what());
        }
        catch (...) {
            croak("Failed to init Yx::StrStrTrie");
        }
    OUTPUT:
        RETVAL

MODULE = Yx::StrStrTrie        PACKAGE = TStrStrTriePtr

bool
is_initialized(self)
    TStrStrTrie* self
    CODE:
        RETVAL = self->IsInitialized();
    OUTPUT:
        RETVAL

bool
is_empty(self)
    TStrStrTrie* self
    CODE:
        RETVAL = self->IsEmpty();
    OUTPUT:
        RETVAL

TString
find(self, key)
    TStrStrTrie* self;
    TString key;
    CODE:
        TString value;
        if (self->Find(key.data(), key.size(), &value)) {
            RETVAL = value;
        }
        else {
            XSRETURN_UNDEF;
        }
    OUTPUT:
        RETVAL

TStrStrTrie::TConstIterator*
begin(self)
    TStrStrTrie* self;
    CODE:
        TStrStrTrie::TConstIterator* b = new TStrStrTrie::TConstIterator(self->Begin());
        RETVAL = b;
    OUTPUT:
        RETVAL


TStrStrTrie::TConstIterator*
end(self)
    TStrStrTrie* self;
    CODE:
        TStrStrTrie::TConstIterator* e = new TStrStrTrie::TConstIterator(self->End());
        RETVAL = e;
    OUTPUT:
        RETVAL

MODULE = Yx::StrStrTrie         PACKAGE = TStrStrTrie::TConstIteratorPtr

TString
value(self)
    TStrStrTrie::TConstIterator* self;
    CODE:
        RETVAL = self->GetValue();
    OUTPUT:
        RETVAL

TString
key(self)
    TStrStrTrie::TConstIterator* self;
    CODE:
        RETVAL = self->GetKey();
    OUTPUT:
        RETVAL

bool
equals(self, other)
    TStrStrTrie::TConstIterator* self;
    TStrStrTrie::TConstIterator* other;
    CODE:
        RETVAL = ( self == other );
    OUTPUT:
        RETVAL

void
advance(self)
    TStrStrTrie::TConstIterator* self;
    CODE:
        (*self)++;

void
retreat(self)
    TStrStrTrie::TConstIterator* self;
    CODE:
        (*self)--;
