
#include <util/stream/file.h>
#include <util/stream/str.h>
#include <util/generic/yexception.h>
#include <util/generic/string.h>

#include <library/cpp/xsltransform/xsltransform.h>

#ifdef _win32_
#   include <winsock2.h>
#   ifdef THIS
#       undef THIS
#   endif
#endif

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#ifdef __cplusplus
}
#endif

#include <contrib/libs/libxslt/extensions.h>
#include <libxml/xpathInternals.h>

template<class T, void (*F)(T*)>
struct TDestroyer {
    static inline void Destroy(T* t) noexcept {
        if (t) F(t);
    }
};

typedef THolder<xmlXPathObject, TDestroyer<xmlXPathObject, xmlXPathFreeObject> > TXPHolder;

void xsltFnToUpper(xmlXPathParserContextPtr ctxt, int nargs) {
    TXPHolder arg1(valuePop(ctxt));
    const TString argument((const char*)arg1->stringval);
    valuePush(ctxt, xmlXPathNewString((xmlChar*)to_upper(argument).data()));
}

void xsltFnToLower(xmlXPathParserContextPtr ctxt, int nargs) {
    TXPHolder arg1(valuePop(ctxt));
    const TString argument((const char*)arg1->stringval);
    valuePush(ctxt, xmlXPathNewString((xmlChar*)to_lower(argument).data()));
}

#include <util/string/util.h>

void xsltFnJSQuote(xmlXPathParserContextPtr ctxt, int nargs) {
    TXPHolder arg1(valuePop(ctxt));
    TString argument((const char*)arg1->stringval);

    static const TString subst("\\/-'");
    for (TString::const_iterator p = subst.begin(); p != subst.end(); ++p) {
        TString from((TString::char_type)*p);
        TString to = TString("\\") + TString((TString::char_type)*p);
        SubstGlobal(argument, from, to);
    }

    static const TString NR("\n\r");
    static const TString RN("\r\n");
    static const TString NN("\n\n");
    static const TString N("\n");
    static const TString EN("\\n");

    size_t len;

    do {
        len = argument.length();

        SubstGlobal(argument, NR, N);
        SubstGlobal(argument, RN, N);
        SubstGlobal(argument, NN, N);
    } while (len != argument.length());

    SubstGlobal(argument, N, EN);

    static const TString QUOTA("'");
    argument = QUOTA + argument + QUOTA;
    valuePush(ctxt, xmlXPathNewString((xmlChar*)argument.data()));
}

#include <library/cpp/string_utils/old_url_normalize/url.h>

void xsltFnURLEncode(xmlXPathParserContextPtr ctxt, int nargs) {
    TXPHolder arg1(valuePop(ctxt)); // XXX: assume it always 'utf-8'
    TXPHolder arg2(valuePop(ctxt));
    const TString argument((const char*)arg2->stringval);
    valuePush(ctxt, xmlXPathNewString((xmlChar*)NormalizeUrl(argument).data()));
}

void xsltFnURLDecode(xmlXPathParserContextPtr ctxt, int nargs) {
    //TODO: just implement
}

template <class T>
struct TDeconstator : public T {
    template <typename U>
    TDeconstator(U u) : T(u){
    }

    T & operator+ () noexcept {
        return *this;
    }
};

class TXScript{
    THolder<TXslTransform> Tr_;

public:
    TXScript(const TString & filename)
        : Tr_(new TXslTransform(+TDeconstator<TFileInput>(filename)))
    {
        Tr_->SetFunction("toupper", "http://www.yandex.ru/xscript", (TxmlXPathFunction)xsltFnToUpper);
        Tr_->SetFunction("tolower", "http://www.yandex.ru/xscript", (TxmlXPathFunction)xsltFnToLower);
        Tr_->SetFunction("js-quote", "http://www.yandex.ru/xscript", (TxmlXPathFunction)xsltFnJSQuote);
        Tr_->SetFunction("urlencode", "http://www.yandex.ru/xscript", (TxmlXPathFunction)xsltFnURLEncode);
        Tr_->SetFunction("urldecode", "http://www.yandex.ru/xscript", (TxmlXPathFunction)xsltFnURLDecode);
    }

    TString convert(const TString & filename) {
        TFileInput xml(filename);
        TStringStream out;

        Tr_->Transform(&xml, &out);
        return out.Str();
    }
    TString convert_text(const TString & text) {
        TStringInput xml(text);
        TStringStream out;

        Tr_->Transform(&xml, &out);
        return out.Str();
    }
};

MODULE = Yx::XScriptStub        PACKAGE = Yx::XScriptStub
PROTOTYPES: ENABLED

TXScript*
TXScript::new(filename)
    const char *filename;
    CODE:
        try {
            RETVAL = new TXScript(filename);
        }
        catch (...) {
            croak("Failed to init Yx::XScriptStub");
        }
    OUTPUT:
        RETVAL

void
TXScript::DESTROY()

TString
TXScript::convert(filename)
    const char* filename;
    CODE:
        try {
            RETVAL = THIS->convert(filename);
        }
        catch (...) {
            croak("Failed to execute Yx::XScriptStub::convert");
        }
    OUTPUT:
        RETVAL

TString
TXScript::convert_text(text)
    const char* text;
    CODE:
        try {
            RETVAL = THIS->convert_text(text);
        }
        catch (...) {
            croak("Failed to execute Yx::XScriptStub::convert_text");
        }
    OUTPUT:
        RETVAL


