package Template::Plugin::XScriptFilter;

use strict;
use warnings;

use Template::Plugin::Filter;
use base qw( Template::Plugin::Filter );

use XScriptStub;

sub init {
    my ($self, $xslt_name) = @_;
    unless ($self->{translator}) {
        $self->{translator} = new Yx::XScriptStub($xslt_name || "index.xsl");; 
    }
    $self->install_filter('xscript');
    return $self;
}

sub filter {
    my ($self, $text) = @_;
    $text =~ s{^\s*}{}s;
    $text =~ s{\s*$}{}s;
    return $self->{translator}->convert_text($fname);
}

=head1 AUTHOR

Sergey Savostyanov <seege@yandex-team.ru>

=cut

1;
