import sys

from yandex_comptrie import WideTrieToWtroka

# trie has been produced by junk/ramzai/trie_string

def main():
    assert len(sys.argv) == 2, 'Usage: cat test.in | python {0} trie'.format(sys.argv[0])
    trie = WideTrieToWtroka()
    trie.Open(sys.argv[1])
    for line in sys.stdin:
        k = line.rstrip('\r\n').split('\t')[0].decode('utf-8')
        try:
            res = trie.Get(k)
        except RuntimeError:
            res = u'NOT_FOUND'
        print u'{0}\t{1}'.format(k, res).encode('utf-8')


if __name__ == '__main__':
    main()
