import pydanet
import skimage.io
import os
import argparse
import numpy
import timeit

def get_layers_output(folder, config, out_file, layer, flip, model, substr):
    pdn = None

    if model:
        pdn = pydanet.pydanet(config=config, model=model)
    else:
        pdn = pydanet.pydanet(config=config)

 
    idx = 0
    fout = open(out_file, 'w')
    fflipped = open("flipped", 'w')
    forig = open("orig", 'w')
    for root, dirs, files in os.walk(folder):
        for file in files:
            cur_path = os.path.join(root, file)
            print cur_path
            if substr and not substr in cur_path:
                continue
            try:
                img = skimage.io.imread(cur_path)
            except IOError:
                print "Wrong file type: %s" % file
                continue
            idx += 1
            
            img = img.copy(order='C')
            features = pdn.Features(img, layer)

            forig.write("%s\t%s\n" % (cur_path, "\t".join(str(x) for x in features)))
            if flip:
                flipped = numpy.fliplr(img)
                flipped = flipped.copy(order='C')
                features_fliped = pdn.Features(flipped, layer)
                fflipped.write("%s\t%s\n" % (cur_path, "\t".join(str(x) for x in features_fliped)))
                features = features + features_fliped

            fout.write("%s\t%s\n" % (cur_path, "\t".join(str(x) for x in features)))

    fout.close()
    fflipped.close()
    forig.close()

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--folder')
    parser.add_argument('--config')
    parser.add_argument('--out_file')
    parser.add_argument('--model')
    parser.add_argument('--layer')
    parser.add_argument('--grep')
    parser.add_argument('--flip', action='store_true')
    #todo flip

    args = parser.parse_args()
    
    model = None
    if hasattr(args, 'model'):
        model = args.model

    get_layers_output(args.folder, args.config, args.out_file, args.layer, args.flip, model, args.grep)

    
