#pragma once

#include <util/generic/yexception.h>

#include <kernel/dssm_applier/nn_applier/lib/layers.h>

#include <string.h>
#include <Python.h>


static void raise_py_error() {
    try {
        if (PyErr_Occurred())
            ; // let the latest Python exn pass through and ignore the current one
        else
            throw;
    } catch (const NNeuralNetApplier::TModel::TInvalidFormatException& ex) {
        PyErr_SetString(PyExc_ValueError, CurrentExceptionMessage().c_str());
    } catch (const TFileError& ex) {
        PyErr_SetString(PyExc_IOError, CurrentExceptionMessage().c_str());
    } catch (const yexception& e) {
        PyErr_SetString(PyExc_RuntimeError, CurrentExceptionMessage().c_str());
    } catch (...) {
        PyErr_SetString(PyExc_RuntimeError, CurrentExceptionMessage().c_str());
    }
}
