#include <Python.h>
#include <kernel/hosts/extowner/ext_owner.h>
#include <library/cpp/pybind/typedesc.h>
#include <util/charset/wide.h>

struct TOwnerExtractorHolder {
    THolder<TOwnerExtractor> OwnerExtractor;

    TOwnerExtractorHolder(TOwnerExtractor *extractor)
        : OwnerExtractor(extractor) {
    }
};

class TOwnerExtractorTraits : public NPyBind::TPythonType<TOwnerExtractorHolder, TOwnerExtractor, TOwnerExtractorTraits> {
private:
    typedef class NPyBind::TPythonType<TOwnerExtractorHolder, TOwnerExtractor, TOwnerExtractorTraits> TParent;
    friend class NPyBind::TPythonType<TOwnerExtractorHolder, TOwnerExtractor, TOwnerExtractorTraits>;
    TOwnerExtractorTraits();

public:
    static TOwnerExtractor *GetObject(const TOwnerExtractorHolder &holder) {
        return holder.OwnerExtractor.Get();
    }

    static TOwnerExtractorHolder *DoInitObject(PyObject *args, PyObject* kwargs);
};

TOwnerExtractorTraits::TOwnerExtractorTraits()
    : TParent("libextowner.TOwnerExtractor", "get owner from url") {
    AddCaller("GetOwner", NPyBind::CreateConstMethodCaller<TOwnerExtractor, TStringBuf, TOwnerExtractor, TStringBuf>(&TOwnerExtractor::GetOwner));
}

TOwnerExtractorHolder *TOwnerExtractorTraits::DoInitObject(PyObject *args, PyObject*) {
    TString areas;
    if (!NPyBind::ExtractArgs(args, areas))
        ythrow yexception() << "Can't create TOwnerExtractor: it should be exactly one parameter - path to areas";
    return new TOwnerExtractorHolder(new TOwnerExtractor(areas));
}

PyMODINIT_FUNC initlibextowner() {
    NPyBind::TPyObjectPtr m = NPyBind::TModuleHolder::Instance().InitModule("libextowner");
    TOwnerExtractorTraits::Instance().Register(m, "TOwnerExtractor");
}
