#include <library/cpp/pybind/typedesc.h>
#include <kernel/qtree/richrequest/richnode.h>
#include <kernel/snippets/strhl/goodwrds.h>
#include <kernel/lemmer/core/langcontext.h>
#include <util/charset/wide.h>

/*
 * class THiliter:
 *   def __init__(self, request=None, qtree=None):
 *      """initialize hiliter object with request or serialized qtree"""
 *   def hilite(self, sentence):
 *      """hilite request keywords from certain sentence"""


 * class THiliteMarks
 *   def __init__(self, open_tag, close_tag):
 *      """initialize marking object"""
 *   @readproperty OpenTag
 *   @readproperty CloseTag

 * SHELL_BOLD_MARKS
 * SHELL_RED_MARKS
 * DEFAULT_MARKS

 */


struct THiliteHolder {
    THolder<TInlineHighlighter> Hiliter;

    THiliteHolder(TInlineHighlighter* hl)
        : Hiliter(hl)
    {}
};


struct THiliteMarkHolder {
    THolder<THiliteMark> Mark;

    THiliteMarkHolder(THiliteMark* mark)
        : Mark(mark)
    {}
};


class THiliterTraits: public NPyBind::TPythonType<THiliteHolder, TInlineHighlighter, THiliterTraits> {
private:
    typedef class NPyBind::TPythonType<THiliteHolder, TInlineHighlighter, THiliterTraits> TParent;
    friend class NPyBind::TPythonType<THiliteHolder, TInlineHighlighter, THiliterTraits>;
    THiliterTraits();
public:
    static TInlineHighlighter* GetObject(const THiliteHolder& holder) {
        return holder.Hiliter.Get();
    }

    static THiliteHolder* DoInitObject(PyObject* args, PyObject* kwargs);
};


class THiliteMarkTraits: public NPyBind::TPythonType<THiliteMarkHolder, THiliteMark, THiliteMarkTraits> {
private:
    typedef class NPyBind::TPythonType<THiliteMarkHolder, THiliteMark, THiliteMarkTraits> TParent;
    friend class NPyBind::TPythonType<THiliteMarkHolder, THiliteMark, THiliteMarkTraits>;
    THiliteMarkTraits();
public:
    static THiliteMark* GetObject(const THiliteMarkHolder& holder) {
        return holder.Mark.Get();
    }

    static THiliteMarkHolder* DoInitObject(PyObject* args, PyObject* kwargs);
};


namespace NPyBind {
    template<>
    inline bool FromPyObject<const THiliteMark*>(PyObject* obj, const THiliteMark*& res) {
        res = THiliteMarkTraits::CastToObject(obj);
        if (res == nullptr)
            return false;
        return true;
    }
}

class THiliteMarkAttrGetter : public NPyBind::TBaseAttrGetter<THiliteMark> {
    public:
        bool GetAttr(PyObject *, const THiliteMark &self, const TString &attr, PyObject *&res) const override {
            if (attr == "OpenTag"sv)
                res = NPyBind::BuildPyObject(self.OpenTag);
            else if (attr == "CloseTag"sv)
                res = NPyBind::BuildPyObject(self.CloseTag);
            else
                res = nullptr;
            return res != nullptr;
        }
};


class THiliteString: public NPyBind::TBaseMethodCaller<TInlineHighlighter> {
public:
    bool CallMethod(PyObject*, TInlineHighlighter* self, PyObject* args, PyObject* /*kwargs*/, PyObject*& res) const override {
        try {
            TUtf16String sentence;
            if (!NPyBind::ExtractArgs(args, sentence))
                ythrow yexception() << "wrong parameters for THiliter::HiliteString()";
            self->PaintPassages(sentence);
            res = NPyBind::BuildPyObject(sentence);
            return true;
        } catch (const std::exception& e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
        }
        res = nullptr;
        return true;
    }
};


THiliterTraits::THiliterTraits()
    : TParent("_hiliter.THiliter", "string hiliting object")
{
    AddCaller("HiliteString", new THiliteString);
}


THiliteMarkTraits::THiliteMarkTraits()
    : TParent("_hiliter.THiliteMarks", "object for encapsulation knowledge about hiliting open/close tags")
{
    AddGetter("", new THiliteMarkAttrGetter);
}


THiliteHolder* THiliterTraits::DoInitObject(PyObject* args, PyObject* kwargs) {
    try {
        TUtf16String request;
        TString qtree;
        const THiliteMark* marks = &DEFAULT_MARKS;
        const char* keywords[] = {"request", "qtree", "marks", nullptr};
        if (!NPyBind::ExtractOptionalArgs(args, kwargs, keywords, request, qtree, marks))
            ythrow yexception() << "wrong parameters for THiliter::__init__()";

        THiliteHolder* result = new THiliteHolder(new TInlineHighlighter);
        TRichTreePtr tree;
        if (! request.empty())
            tree = CreateRichTree(request, TCreateTreeOptions(LI_BASIC_LANGUAGES));
        else if (! qtree.empty())
            tree = DeserializeRichTree(DecodeRichTreeBase64(qtree));
        else
            ythrow yexception() << "at least one option ('request' or 'qtree') must be passed for THiliter::__init__()";
        result->Hiliter->AddRequest(*tree->Root.Get(), marks, false);
        return result;
    } catch (const std::exception& e) {
        PyErr_SetString(PyExc_RuntimeError, e.what());
    }
    return nullptr;
}

THiliteMarkHolder* THiliteMarkTraits::DoInitObject(PyObject* args, PyObject*) {
    try {
        {
            TUtf16String openTag, closeTag;
            if (NPyBind::ExtractArgs(args, openTag, closeTag)) {
                return new THiliteMarkHolder(new THiliteMark(openTag, closeTag));
            }
        }
        {
            TStringBuf openTag, closeTag;
            if (NPyBind::ExtractArgs(args, openTag, closeTag)) {
                return new THiliteMarkHolder(new THiliteMark(openTag.data(), closeTag.data()));
            }
        }
        ythrow yexception() << "wrong parameters for THiliteMarks::__init__()";
    } catch (const std::exception& e) {
        PyErr_SetString(PyExc_RuntimeError, e.what());
    }
    return nullptr;
}


static PyMethodDef _HiliterMethods[] = {
    {nullptr, nullptr, 0, nullptr}
};


PyMODINIT_FUNC init_hiliter() {
    PyObject* m =Py_InitModule("_hiliter", _HiliterMethods);
    THiliterTraits::Instance().Register(m, "THiliter");
    THiliteMarkTraits::Instance().Register(m, "THiliteMarks");
    THiliteMarkTraits::Instance().Register(m, "SHELL_BOLD_MARKS", new THiliteMarkHolder(new THiliteMark("\x1b[1m", "\x1b[m")));
    THiliteMarkTraits::Instance().Register(m, "SHELL_RED_MARKS", new THiliteMarkHolder(new THiliteMark("\x1b[1;31m", "\x1b[m")));
    THiliteMarkTraits::Instance().Register(m, "DEFAULT_MARKS", new THiliteMarkHolder(new THiliteMark(DEFAULT_MARKS.OpenTag, DEFAULT_MARKS.CloseTag)));
}

