#!/usr/bin/python

from ctypes import *;
from os import sys;

class NormalizeError(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

class Normalize:
    def __init__(self):
        self.so = CDLL("libhtnormso.so")
    def normalize(self, doc, base = "http://127.0.0.1"):
        srcLen = len(doc)
        resDoc = c_char_p()
        resLen = c_int()
        r = self.so.NormalizeHtml(doc, srcLen, base, byref(resDoc), byref(resLen))
        result = resDoc.value
        self.so.ReleaseNormalized(resDoc)
        if(r):
            raise NormalizeError(result)
        return result

def main():
    inp = open(sys.argv[1])
    source = inp.read()
    norm = Normalize()
    base = None
    if(len(sys.argv) > 2): 
        base = sys.argv[2]
        result = norm.normalize(source, base)
    else:
        result = norm.normalize(source)

    print result

main()
