#include "conniter.h"

namespace {
    class TNextCaller : public NPyBind::TBaseMethodCaller<TConnIterator> {
    public:
        bool CallMethod(PyObject *, TConnIterator *self, PyObject *args, PyObject*, PyObject *&res) const override {
            if (!NPyBind::ExtractArgs(args))
                ythrow NPyBind::TPyErr(PyExc_TypeError) << "ConnIterator.Next(): has no arguments";
            const TConnData* connData = self->Next();
            if (connData) {
                THolder<TConnDataHolder> holder(new TConnDataHolder(const_cast<TConnData*>(connData)));
                NPyBind::TPyObjectPtr pyConnData = TConnDataTraits::Instance().CreatePyObject(holder.Get());
                Y_UNUSED(holder.Release());
                res = pyConnData.RefGet();
            } else {
                res = (Py_INCREF(Py_None), Py_None);
            }
            return true;
        }
    };

    static void ParseHostInfo(TConnIterator::THostInfo& /*hostInfo*/, PyObject* /*props*/) {
    }

    class TSetClientStatusCaller : public NPyBind::TBaseMethodCaller<TConnIterator> {
    public:
        bool CallMethod(PyObject *, TConnIterator *self, PyObject *args, PyObject*, PyObject *&res) const override {
            NPyBind::TPyObjectPtr conn;
            ui64 answerTime = 0;
            NPyBind::TPyObjectPtr props;
            if (!NPyBind::ExtractArgs(args, conn, answerTime, props))
                ythrow NPyBind::TPyErr(PyExc_TypeError) << "ConnIterator.SetClientStatus(conn, answerTime, props): has three arguments";
            TConnData* connData = TConnDataTraits::Instance().CastToObject(conn.Get());
            TConnIterator::THostInfo hostInfo;
            ParseHostInfo(hostInfo, props.Get());
            self->SetClientStatus(connData, answerTime, hostInfo);
            res = (Py_INCREF(Py_None), Py_None);
            return true;
        }
    };
}

TConnIteratorTraits::TConnIteratorTraits()
    : TParent("httpsearchclient.ConnIterator", "")
{
    AddCaller("Next", new TNextCaller);
    AddCaller("SetClientStatus", new TSetClientStatusCaller);
}

namespace {
    class TConnDataGetter : public NPyBind::TBaseAttrGetter<TConnData> {
    public:
        bool GetAttr(PyObject *, const TConnData &self, const TString& name, PyObject *&res) const override {
            if (name == "Registered") {
                res = NPyBind::BuildPyObject(self.Registered());
            } else if (name == "IsMain") {
                res = NPyBind::BuildPyObject(self.IsMain());
            } else if (name == "Ip") {
                res = NPyBind::BuildPyObject(self.Ip());
            } else if (name == "Port") {
                res = NPyBind::BuildPyObject(self.Port());
            } else if (name == "SearchScript") {
                res = NPyBind::BuildPyObject(self.SearchScript());
            } else if (name == "Host") {
                res = NPyBind::BuildPyObject(self.Host());
            } else if (name == "Path") {
                res = NPyBind::BuildPyObject(self.Path());
            } else if (name == "GroupDescr") {
                res = NPyBind::BuildPyObject(self.GroupDescr());
            } else if (name == "IndexGeneration") {
                res = NPyBind::BuildPyObject(self.IndexGeneration());
            } else if (name == "SourceTimestamp") {
                res = NPyBind::BuildPyObject(self.SourceTimestamp());
            } else {
                ythrow NPyBind::TPyErr(PyExc_NameError) << "ConnData does not have attribute " << name;
            }
            return true;
        }

        bool HasAttr(PyObject *owner, const TConnData &self, const TString &attr, const TSet<TString> &hiddenNames) const override {
            if (PyErr_Occurred())
                return false;
            bool result = false;
            try {
                result = NPyBind::TBaseAttrGetter<TConnData>::HasAttr(owner, self, attr, hiddenNames);
            } catch (const NPyBind::TPyErr&) {
                return false;
            }
            if (PyErr_Occurred())
                PyErr_Clear(); // ignore python exceptions if were set while calling GetAttr()
            return result;
        }
    };
}

TConnDataTraits::TConnDataTraits()
    : TParent("httpsearchclient.ConnData", "")
{
    NPyBind::TAttrGetters<TConnData>::TGetterPtr getter(new TConnDataGetter);
    AddGetter("Registered", getter);
    AddGetter("IsMain", getter);
    AddGetter("Ip", getter);
    AddGetter("Port", getter);
    AddGetter("SearchScript", getter);
    AddGetter("Host", getter);
    AddGetter("Path", getter);
    AddGetter("GroupDescr", getter);
    AddGetter("IndexGeneration", getter);
    AddGetter("SourceTimestamp", getter);
}
