#pragma once

#include <kernel/httpsearchclient/conniterator.h>

#include <library/cpp/pybind/typedesc.h>

class TConnIteratorHolder {
public:
    TConnIteratorHolder(NPyBind::TPyObjectPtr parent, TConnIterator&& iter)
        : Parent(parent)
        , Iterator(std::move(iter))
    {
    }

    TConnIterator* Get() {
        return &Iterator;
    }

private:
    NPyBind::TPyObjectPtr Parent;
    TConnIterator Iterator;
};

class TConnIteratorTraits : public NPyBind::TPythonType<TConnIteratorHolder, TConnIterator, TConnIteratorTraits> {
private:
    typedef class NPyBind::TPythonType<TConnIteratorHolder, TConnIterator, TConnIteratorTraits> TParent;
    friend class NPyBind::TPythonType<TConnIteratorHolder, TConnIterator, TConnIteratorTraits>;
    TConnIteratorTraits();

public:
    static TConnIterator *GetObject(TConnIteratorHolder& holder) {
        return holder.Get();
    }
};

// holder that does not destroy referenced object on delete
struct TConnDataHolder {
    TConnData* ConnData;

    TConnDataHolder(TConnData* connData)
        : ConnData(connData)
    {
    }
};

class TConnDataTraits : public NPyBind::TPythonType<TConnDataHolder, TConnData, TConnDataTraits> {
private:
    typedef class NPyBind::TPythonType<TConnDataHolder, TConnData, TConnDataTraits> TParent;
    friend class NPyBind::TPythonType<TConnDataHolder, TConnData, TConnDataTraits>;
    TConnDataTraits();

public:
    static TConnData *GetObject(TConnDataHolder &holder) {
        return holder.ConnData;
    }
};
