#include "module.h"
#include "conniter.h"
#include "httpsearchclient.h"

#include <infra/yp_service_discovery/libs/sdlib/grpc_resolver/grpc_resolver.h>
#include <infra/yp_service_discovery/libs/sdlib/config/config.h>
#include <util/stream/str.h>

THttpSearchClient::THttpSearchClient(PyObject* args, PyObject* kwargs) {
    ServiceDiscoveryOptions.SetPort(8081); // grpc port
    ParseArgs(args, kwargs);
    if (ServiceDiscoveryOptions.Enabled) {
        SdManager.Reset(new NYP::NServiceDiscovery::TEndpointSetManager(
            ServiceDiscoveryOptions,
            MakeAtomicShared<NYP::NServiceDiscovery::TGrpcResolver>(ServiceDiscoveryOptions, TDuration::MilliSeconds(100))
        ));
        SdManager->Start(TDuration::Minutes(1), NYP::NServiceDiscovery::TEndpointSetManager::TUpdateMode());
    }
    Base_.Reset(new NScatter::TMutableSource(Descr, Num, Script, Options, GroupId, SdManager.Get()));
    Module = NPyBind::TPyObjectPtr(MyModule);
}

void THttpSearchClient::ParseArgs(PyObject* args, PyObject* kwargs) {
    if (!NPyBind::ExtractArgs(args)) {
        ythrow NPyBind::TPyErr(PyExc_TypeError) << "HttpSearchClient.__init__() takes no positional arguments";
    }
    if (!kwargs || !PyDict_Check(kwargs)) {
        ythrow NPyBind::TPyErr(PyExc_TypeError) << "HttpSearchClient.__init__() takes only named arguments";
    }

    NPyBind::TPyObjectPtr descr(PyDict_GetItemString(kwargs, "Descr"));
    if (!!descr) {
        if (!NPyBind::FromPyObject(descr.Get(), Descr)) {
            ythrow NPyBind::TPyErr(PyExc_TypeError) << "HttpSearchClient.__init__() named argument Descr must be a string";
        }
    }

    NPyBind::TPyObjectPtr script(PyDict_GetItemString(kwargs, "Script"));
    if (!script) {
        ythrow NPyBind::TPyErr(PyExc_KeyError) << "HttpSearchClient.__init__() must have named argument: Script";
    }
    if (!NPyBind::FromPyObject(script.Get(), Script)) {
        ythrow NPyBind::TPyErr(PyExc_TypeError) << "HttpSearchClient.__init__() named argument Script must be a string";
    }

    NPyBind::TPyObjectPtr options(PyDict_GetItemString(kwargs, "Options"));
    if (!!options) {
        TString optionsString;
        if (!NPyBind::FromPyObject(options.Get(), optionsString)) {
            ythrow NPyBind::TPyErr(PyExc_TypeError) << "HttpSearchClient.__init__() named argument Options must be a string";
        }
        Options.Parse(optionsString);
    }

    NPyBind::TPyObjectPtr groupId(PyDict_GetItemString(kwargs, "GroupId"));
    if (!!groupId) {
        if (!NPyBind::FromPyObject(groupId.Get(), GroupId)) {
            ythrow NPyBind::TPyErr(PyExc_TypeError) << "HttpSearchClient.__init__() named argument GroupId must be a string";
        }
    }

    NPyBind::TPyObjectPtr sdOptions(PyDict_GetItemString(kwargs, "ServiceDiscoveryOptions"));
    if (!!sdOptions) {
        TString sdOptionsString;
        if (!NPyBind::FromPyObject(sdOptions.Get(), sdOptionsString)) {
            ythrow NPyBind::TPyErr(PyExc_TypeError) <<
                "HttpSearchClient.__init__() named argument ServiceDiscoveryOptions must be a string";
        }
        ServiceDiscoveryOptions.Parse(sdOptionsString);
    }
}

namespace {
    class TPossibleConnectionsCaller : public NPyBind::TBaseMethodCaller<THttpSearchClient> {
    public:
        bool CallMethod(PyObject* owner, THttpSearchClient* self, PyObject* args, PyObject*, PyObject* &res) const override {
            NHttpSearchClient::TRequestHash hash;
            if (!NPyBind::ExtractArgs(args, hash))
                ythrow NPyBind::TPyErr(PyExc_TypeError) << "HttpSearchClient.PossibleConnections(hash): hash must be an integer";
            TConnIterator iter = self->PossibleConnections(hash);
            THolder<TConnIteratorHolder> holder(new TConnIteratorHolder(NPyBind::TPyObjectPtr(owner), std::move(iter)));
            NPyBind::TPyObjectPtr pyIter = TConnIteratorTraits::Instance().CreatePyObject(holder.Get());
            Y_UNUSED(holder.Release());
            res = pyIter.RefGet();
            return true;
        }
    };

    class TOptionsGetter : public NPyBind::TBaseAttrGetter<THttpSearchClient> {
    public:
        bool GetAttr(PyObject* owner, const THttpSearchClient &self, const TString&, PyObject *&res) const override {
            THolder<TSourceOptionsHolder> holder(new TSourceOptionsHolder(NPyBind::TPyObjectPtr(owner), self.GetOptions()));
            NPyBind::TPyObjectPtr pyIter = TSourceOptionsTraits::Instance().CreatePyObject(holder.Get());
            Y_UNUSED(holder.Release());
            res = pyIter.RefGet();
            return true;
        }

        bool HasAttr(PyObject*, const THttpSearchClient&, const TString&, const TSet<TString>&) const override {
            return true;
        }
    };
}

THttpSearchClientTraits::THttpSearchClientTraits()
    : TParent("httpsearchclient.HttpSearchClient", "")
{
    AddCaller("PossibleConnections", new TPossibleConnectionsCaller);
    AddGetter("Options", new TOptionsGetter);
}

THttpSearchClient* THttpSearchClientTraits::DoInitObject(PyObject* args, PyObject* kwargs) {
    return new THttpSearchClient(args, kwargs);
}

namespace {
    class TSourceOptionsGetter : public NPyBind::TBaseAttrGetter<const NScatter::TSourceOptions> {
    public:
        bool GetAttr(PyObject *, const NScatter::TSourceOptions &self, const TString& name, PyObject *&res) const override {
            if (name == "MaxAttempts") {
                res = NPyBind::BuildPyObject(self.MaxAttempts);
            } else {
                ythrow NPyBind::TPyErr(PyExc_NameError) << "BalancingOptions does not have attribute " << name;
            }
            return true;
        }

        bool HasAttr(PyObject *owner, const NScatter::TSourceOptions &self, const TString &attr, const TSet<TString> &hiddenNames) const override {
            if (PyErr_Occurred())
                return false;
            bool result = false;
            try {
                result = NPyBind::TBaseAttrGetter<const NScatter::TSourceOptions>::HasAttr(owner, self, attr, hiddenNames);
            } catch (const NPyBind::TPyErr&) {
                return false;
            }
            if (PyErr_Occurred())
                PyErr_Clear(); // ignore python exceptions if were set while calling GetAttr()
            return result;
        }
    };
}

TSourceOptionsTraits::TSourceOptionsTraits()
    : TParent("httpsearchclient.BalancingOptions", "")
{
    NPyBind::TAttrGetters<const NScatter::TSourceOptions>::TGetterPtr getter(new TSourceOptionsGetter);
    AddGetter("MaxAttempts", getter);
}
