#pragma once

#include <kernel/httpsearchclient/httpsearchclient.h>
#include <search/meta/scatter/sd.h>
#include <search/meta/scatter/options.h>
#include <search/config/virthost.h> // TServiceDiscoveryOptions
#include <infra/yp_service_discovery/libs/sdlib/config/config.h>

#include <library/cpp/pybind/typedesc.h>

class THttpSearchClient: public TConnGroup {
public:
    THttpSearchClient(PyObject* args, PyObject *kwargs);

    inline TConnIterator PossibleConnections(const NHttpSearchClient::TRequestHash hash) const {
        NHttpSearchClient::TSeed seed(hash);
        return TConnIterator(Base_->GetSearchConnections(seed));
    }

    const NScatter::TSourceOptions& GetOptions() const {
        return Options;
    }

private:
    void ParseArgs(PyObject* args, PyObject *kwargs);

private:
    TString Script;
    NScatter::TSourceOptions Options;
    TString GroupId;
    TString Descr="";
    size_t Num=0;
    THolder<NScatter::TMutableSource> Base_;
    NPyBind::TPyObjectPtr Module;

    THolder<NYP::NServiceDiscovery::TEndpointSetManager> SdManager=nullptr;
    TServiceDiscoveryOptions ServiceDiscoveryOptions;

};

class THttpSearchClientTraits : public NPyBind::TPythonType<THttpSearchClient, THttpSearchClient, THttpSearchClientTraits> {
private:
    typedef class NPyBind::TPythonType<THttpSearchClient, THttpSearchClient, THttpSearchClientTraits> TParent;
    friend class NPyBind::TPythonType<THttpSearchClient, THttpSearchClient, THttpSearchClientTraits>;
    THttpSearchClientTraits();

public:
    static THttpSearchClient *GetObject(THttpSearchClient &holder) {
        return &holder;
    }

    static THttpSearchClient *DoInitObject(PyObject *args, PyObject *kwargs);
};

class TSourceOptionsHolder {
public:
    TSourceOptionsHolder(NPyBind::TPyObjectPtr parent, const NScatter::TSourceOptions& options)
        : Parent(parent)
        , Options(options)
    {
    }

    const NScatter::TSourceOptions* Get() const {
        return &Options;
    }

private:
    NPyBind::TPyObjectPtr Parent;
    const NScatter::TSourceOptions& Options;
};

class TSourceOptionsTraits : public NPyBind::TPythonType<TSourceOptionsHolder, const NScatter::TSourceOptions, TSourceOptionsTraits> {
private:
    typedef class NPyBind::TPythonType<TSourceOptionsHolder, const NScatter::TSourceOptions, TSourceOptionsTraits> TParent;
    friend class NPyBind::TPythonType<TSourceOptionsHolder, const NScatter::TSourceOptions, TSourceOptionsTraits>;
    TSourceOptionsTraits();

public:
    static const NScatter::TSourceOptions* GetObject(const TSourceOptionsHolder& holder) {
        return holder.Get();
    }
};
