#include "module.h"

#include <kernel/httpsearchclient/httpsearchclient.h>

#include <library/cpp/svnversion/svnversion.h>
#include <library/cpp/pybind/module.h>
#include <library/cpp/pybind/cast.h>

#include <util/string/printf.h>

PyObject* MyModule = nullptr;

namespace {
    static PyObject* DoSetOption(const TString& name, PyObject* value) {
        if (name == "SmoothThreshold") {
            size_t prevValue = NHttpSearchClient::SmoothThreshold;
            NHttpSearchClient::SmoothThreshold = NPyBind::FromPyObject<size_t>(value);
            return NPyBind::BuildPyObject(prevValue);
        }

        PyErr_SetString(PyExc_NameError, Sprintf("unknown option name: %s", name.data()).data());
        return nullptr;
    }

    PyObject* SetOption(PyObject*, PyObject* args) {
        TString name;
        NPyBind::TPyObjectPtr value;
        if (!NPyBind::ExtractArgs(args, name, value)) {
            PyErr_SetString(PyExc_TypeError, "set_option() takes exactly 2 arguments: name, value");
            return nullptr;
        }
        return DoSetOption(name, value.Get());
    }

    PyObject* SetOptions(PyObject*, PyObject* args) {
        NPyBind::TPyObjectPtr dict;
        if (!NPyBind::ExtractArgs(args, dict) || !PyDict_Check(dict.Get())) {
            PyErr_SetString(PyExc_TypeError, "set_options() takes exactly 1 argument: dict");
            return nullptr;
        }

        PyObject *key = nullptr, *value = nullptr;
        Py_ssize_t pos = 0;
        while (PyDict_Next(dict.Get(), &pos, &key, &value)) {
            TString name = NPyBind::FromPyObject<TString>(key);
            NPyBind::TPyObjectPtr prevValue(DoSetOption(name, value), true);
            if (PyErr_Occurred())
                return nullptr;
        }

        Py_RETURN_NONE;
    }

    PyObject* GetOptions(PyObject*, PyObject* args) {
        if (!NPyBind::ExtractArgs(args)) {
            PyErr_SetString(PyExc_TypeError, "get_options() takes no arguments");
            return nullptr;
        }

        NPyBind::TPyObjectPtr dict(PyDict_New(), true);
        PyDict_SetItemString(dict.Get(), "SmoothThreshold", NPyBind::BuildPyObject(NHttpSearchClient::SmoothThreshold));
        return dict.RefGet();
    }

    PyObject* GetVersion(PyObject*, PyObject* args) {
        if (!NPyBind::ExtractArgs(args)) {
            PyErr_SetString(PyExc_TypeError, "get_version() takes no arguments");
            return nullptr;
        }

        return NPyBind::BuildPyObject(PROGRAM_VERSION);
    }
}

void AddModuleMethods(NPyBind::TModuleHolder& module) {
    module.AddModuleMethod<SetOption>("set_option", "set_option(name, value) -> prev_value\n\nSet module option with name and value. Returns previous value of the option.");
    module.AddModuleMethod<GetOptions>("get_options", "get_options() -> dict\n\nReturns module options as a dictionary.");
    module.AddModuleMethod<SetOptions>("set_options", "set_options(dict)\n\nSet module options using dictionary.");
    module.AddModuleMethod<GetVersion>("get_version", "get_version() -> string\n\nReturns arcadia version as reported by library/cpp/svnversion.");
}
